/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.exchange.DestinationReferrer;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInfo;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.AlternateBinding;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.Initialization;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.OverflowPolicy;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.model.QueueNotificationListener;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.CreatingLinkInfo;
import org.apache.qpid.server.queue.MessageGroupType;
import org.apache.qpid.server.queue.NotificationCheck;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.util.Deletable;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

@ManagedObject(defaultType="standard", amqpName="org.apache.qpid.Queue", description="<p>Queues are named entities within a VirtualHost that hold/buffer messages for later delivery to consumer applications. Consumers subscribe to a queue in order to receive messages for it.</p><p>The Broker supports different queue types, each with different delivery semantics. It also allows for messages on a queue to be treated as a group.</p>")
public interface Queue<X extends Queue<X>>
extends ConfiguredObject<X>,
Comparable<X>,
DestinationReferrer,
BaseQueue,
MessageSource,
MessageDestination,
Deletable<X> {
    public static final String CLASS_DESCRIPTION = "<p>Queues are named entities within a VirtualHost that hold/buffer messages for later delivery to consumer applications. Consumers subscribe to a queue in order to receive messages for it.</p><p>The Broker supports different queue types, each with different delivery semantics. It also allows for messages on a queue to be treated as a group.</p>";
    public static final String ALERT_REPEAT_GAP = "alertRepeatGap";
    public static final String ALERT_THRESHOLD_MESSAGE_AGE = "alertThresholdMessageAge";
    public static final String ALERT_THRESHOLD_MESSAGE_SIZE = "alertThresholdMessageSize";
    public static final String ALERT_THRESHOLD_QUEUE_DEPTH_BYTES = "alertThresholdQueueDepthBytes";
    public static final String ALERT_THRESHOLD_QUEUE_DEPTH_MESSAGES = "alertThresholdQueueDepthMessages";
    public static final String ALTERNATE_BINDING = "alternateBinding";
    public static final String EXCLUSIVE = "exclusive";
    public static final String MESSAGE_DURABILITY = "messageDurability";
    public static final String MESSAGE_GROUP_KEY_OVERRIDE = "messageGroupKeyOverride";
    public static final String MESSAGE_GROUP_TYPE = "messageGroupType";
    public static final String MESSAGE_GROUP_DEFAULT_GROUP = "messageGroupDefaultGroup";
    public static final String MAXIMUM_DELIVERY_ATTEMPTS = "maximumDeliveryAttempts";
    public static final String NO_LOCAL = "noLocal";
    public static final String OWNER = "owner";
    public static final String CREATING_LINK_INFO = "creatingLinkInfo";
    public static final String QUEUE_FLOW_STOPPED = "queueFlowStopped";
    public static final String MAXIMUM_MESSAGE_TTL = "maximumMessageTtl";
    public static final String MINIMUM_MESSAGE_TTL = "minimumMessageTtl";
    public static final String DEFAULT_FILTERS = "defaultFilters";
    public static final String ENSURE_NONDESTRUCTIVE_CONSUMERS = "ensureNondestructiveConsumers";
    public static final String HOLD_ON_PUBLISH_ENABLED = "holdOnPublishEnabled";
    public static final String OVERFLOW_POLICY = "overflowPolicy";
    public static final String MAXIMUM_QUEUE_DEPTH_MESSAGES = "maximumQueueDepthMessages";
    public static final String MAXIMUM_QUEUE_DEPTH_BYTES = "maximumQueueDepthBytes";
    public static final String EXPIRY_POLICY = "expiryPolicy";
    public static final String MAXIMUM_LIVE_CONSUMERS = "maximumLiveConsumers";
    public static final String QUEUE_SCAVANGE_COUNT = "qpid.queue.scavenge_count";
    @ManagedContextDefault(name="qpid.queue.scavenge_count")
    public static final int DEFAULT_QUEUE_SCAVANGE_COUNT = 100;
    public static final String MIME_TYPE_TO_FILE_EXTENSION = "qpid.mimeTypeToFileExtension";
    @ManagedContextDefault(name="qpid.mimeTypeToFileExtension", description="A mapping of MIME types to file extensions.")
    public static final String DEFAULT_MIME_TYPE_TO_FILE_EXTENSION = "{\"application/json\":\".json\",\"application/pdf\":\".pdf\",\"application/xml\":\".xml\",\"image/jpeg\":\".jpg\",\"image/tiff\":\".tiff\",\"text/plain\":\".txt\"}";
    public static final String QUEUE_DEFAULT_ALTERNATE_BINDING = "queue.defaultAlternateBinding";
    @ManagedContextDefault(name="queue.defaultAlternateBinding", description="the ExclusivityPolicy to apply to queues where none is explicitly set")
    public static final String DEFAULT_ALTERNATE_BINDING = "";
    public static final String QUEUE_DEFAULT_EXCLUSIVITY_POLICY = "queue.defaultExclusivityPolicy";
    @ManagedContextDefault(name="queue.defaultExclusivityPolicy", description="the ExclusivityPolicy to apply to queues where none is explicitly set")
    public static final String DEFAULT_EXCLUSIVITY = "NONE";
    @ManagedContextDefault(name="queue.defaultEnsureNonDestructiveConsumers", description="the value to use for the ensureNondestructiveCnsumers attribute of a queue where none is explicitly set")
    public static final String DEFAULT_ENSURE_NON_DESTRUCTIVE_CONSUMERS = "false";
    public static final String MESSAGE_CONVERSION_EXCEPTION_HANDLING_POLICY = "qpid.queue.messageConversion.exceptionHandlingPolicy";
    @ManagedContextDefault(name="qpid.queue.messageConversion.exceptionHandlingPolicy", description="The behaviour of consumer if it tries to consumer a messages that it cannot convert.")
    public static final MessageSource.MessageConversionExceptionHandlingPolicy DEFAULT_MESSAGE_CONVERSION_EXCEPTION_HANDLING_POLICY = MessageSource.MessageConversionExceptionHandlingPolicy.REJECT;
    public static final String UNKNOWN_QUEUE_DECLARE_ARGUMENT_BEHAVIOUR_NAME = "queue.behaviourOnUnknownDeclareArgument";
    @ManagedContextDefault(name="queue.behaviourOnUnknownDeclareArgument")
    public static final BehaviourOnUnknownDeclareArgument ON_UNKNOWN_QUEUE_DECLARE_OPTION = BehaviourOnUnknownDeclareArgument.FAIL;
    @ManagedContextDefault(name="qpid.broker_default-shared-message-group")
    public static final String DEFAULT_SHARED_MESSAGE_GROUP = "qpid.no-group";
    @ManagedContextDefault(name="queue.maximumDistinctGroups")
    public static final int DEFAULT_MAXIMUM_DISTINCT_GROUPS = 255;
    @ManagedContextDefault(name="queue.messageGroupType")
    public static final MessageGroupType DEFAULT_MESSAGE_GROUP_TYPE = MessageGroupType.NONE;
    @ManagedContextDefault(name="queue.maximumDeliveryAttempts")
    public static final int DEFAULT_MAXIMUM_DELIVERY_ATTEMPTS = 0;
    public static final String QUEUE_FLOW_RESUME_LIMIT = "queue.queueFlowResumeLimit";
    @ManagedContextDefault(name="queue.queueFlowResumeLimit", description="Percentage used to evaluate flow resume limit based on the values of attributes 'maximumQueueDepthBytes' and 'maximumQueueDepthMessages'.")
    public static final double DEFAULT_FLOW_CONTROL_RESUME_LIMIT = 80.0;
    @ManagedContextDefault(name="queue.alertThresholdMessageAge")
    public static final long DEFAULT_ALERT_THRESHOLD_MESSAGE_AGE = 0L;
    @ManagedContextDefault(name="queue.alertThresholdMessageSize")
    public static final long DEFAULT_ALERT_THRESHOLD_MESSAGE_SIZE = 0L;
    @ManagedContextDefault(name="queue.alertThresholdQueueDepthBytes")
    public static final long DEFAULT_ALERT_THRESHOLD_QUEUE_DEPTH = 0L;
    @ManagedContextDefault(name="queue.alertThresholdQueueDepthMessages")
    public static final long DEFAULT_ALERT_THRESHOLD_MESSAGE_COUNT = 0L;
    @ManagedContextDefault(name="queue.alertRepeatGap")
    public static final long DEFAULT_ALERT_REPEAT_GAP = 30000L;
    @ManagedContextDefault(name="queue.defaultMessageDurability", description="the value to use for the messageDurability attribute of a queue where none is explicitly set")
    public static final String DEFAULT_MESSAGE_DURABILTY = "DEFAULT";
    @ManagedContextDefault(name="queue.minimumMessageTtl", description="the value to use for the minimumMessageTtl attribute of a queue where none is explicitly set")
    public static final long DEFAULT_MINIMUM_MESSAGE_TTL = 0L;
    @ManagedContextDefault(name="queue.maximumMessageTtl", description="the value to use for the maximumMessageTtl attribute of a queue where none is explicitly set")
    public static final long DEFAULT_MAXIMUM_MESSAGE_TTL = 0L;
    @ManagedContextDefault(name="queue.holdOnPublishEnabled")
    public static final boolean DEFAULT_HOLD_ON_PUBLISH_ENABLED = false;
    @ManagedContextDefault(name="queue.defaultMaximumQueueDepthMessages", description="Maximum number of messages on queue allowed by overflow policy.")
    public static final long DEFAULT_MAXIMUM_QUEUE_DEPTH_MESSAGES = -1L;
    @ManagedContextDefault(name="queue.defaultMaximumQueueDepthBytes", description="Maximum number of bytes on queue allowed by overflow policy.")
    public static final long DEFAULT_MAXIMUM_QUEUE_DEPTH_BYTES = -1L;
    @ManagedContextDefault(name="queue.defaultOverflowPolicy", description="Specifies the default value for queue overflow policy. ")
    public static final OverflowPolicy DEFAULT_OVERFLOW_POLICY = OverflowPolicy.NONE;
    @ManagedContextDefault(name="queue.defaultExpiryPolicy", description="Specifies the default value for queue expiry policy. ")
    public static final ExpiryPolicy DEFAULT_EXPIRY_POLICY = ExpiryPolicy.DELETE;
    @ManagedContextDefault(name="queue.defaultMaximumLiveConsumers", description="Specifies the default value for maximum live consumers. ")
    public static final int DEFAULT_MAXIMUM_LIVE_CONSUMERS = 0;

    @ManagedAttribute(defaultValue="${queue.defaultAlternateBinding}", initialization=Initialization.materialize, description="Provides an alternate destination that will be used when the number of delivery attempts exceeds the maximumDeliveryAttempt configured on this queue.  Messages are also routed to this destination if this queue is deleted.")
    public AlternateBinding getAlternateBinding();

    @ManagedAttribute(defaultValue="${queue.defaultExclusivityPolicy}")
    public ExclusivityPolicy getExclusive();

    @ManagedAttribute(defaultValue="${queue.defaultEnsureNonDestructiveConsumers}")
    public boolean isEnsureNondestructiveConsumers();

    @DerivedAttribute(persist=true)
    public String getOwner();

    @ManagedAttribute(immutable=true, description="Information about the AMQP 1.0 Link that created this Queue if any.")
    public CreatingLinkInfo getCreatingLinkInfo();

    @ManagedAttribute
    public boolean isNoLocal();

    @ManagedAttribute(description="Specifies the name of the message header that provides the value for message grouping purposes. If not set, for AMQP 1.0 the value of the group-id field within the message properties is used. For AMQP 0-8..0-10, the value of the message header JMSXGroupId is used.", validValuePattern="^(?!\\s*$).+")
    public String getMessageGroupKeyOverride();

    @ManagedAttribute(defaultValue="${qpid.broker_default-shared-message-group}", description="Fallback group used for messages without a group identifier. Used by SHARED_GROUPS only.", validValuePattern="^(?!\\s*$).+")
    public String getMessageGroupDefaultGroup();

    @ManagedAttribute(defaultValue="${queue.maximumDistinctGroups}", description="Maximum number of distinct groups.  Used by STANDARD groups only")
    public int getMaximumDistinctGroups();

    @ManagedAttribute(defaultValue="${queue.messageGroupType}")
    public MessageGroupType getMessageGroupType();

    @ManagedAttribute(defaultValue="${queue.maximumDeliveryAttempts}")
    public int getMaximumDeliveryAttempts();

    @DerivedAttribute
    public boolean isQueueFlowStopped();

    @Override
    @DerivedAttribute
    public MessageSource.MessageConversionExceptionHandlingPolicy getMessageConversionExceptionHandlingPolicy();

    @ManagedAttribute(defaultValue="${queue.alertThresholdMessageAge}")
    public long getAlertThresholdMessageAge();

    @ManagedAttribute(defaultValue="${queue.alertThresholdMessageSize}")
    public long getAlertThresholdMessageSize();

    @ManagedAttribute(defaultValue="${queue.alertThresholdQueueDepthBytes}")
    public long getAlertThresholdQueueDepthBytes();

    @ManagedAttribute(defaultValue="${queue.alertThresholdQueueDepthMessages}")
    public long getAlertThresholdQueueDepthMessages();

    @ManagedAttribute(defaultValue="${queue.alertRepeatGap}")
    public long getAlertRepeatGap();

    @Override
    @ManagedAttribute(defaultValue="${queue.defaultMessageDurability}")
    public MessageDurability getMessageDurability();

    @ManagedAttribute(defaultValue="${queue.minimumMessageTtl}", description="Minimum message time to live (TTL) in ms. Messages arriving with smaller TTL values will be overridden by this value")
    public long getMinimumMessageTtl();

    @ManagedAttribute(defaultValue="${queue.maximumMessageTtl}", description="Maximum message time to live (TTL) in ms. Messages arriving with larger TTL values (including those with no TTL, which are considered to have a TTL value of infinity) will be overridden by this value.")
    public long getMaximumMessageTtl();

    @ManagedAttribute
    public Map<String, Map<String, List<String>>> getDefaultFilters();

    @ManagedAttribute(defaultValue="${queue.holdOnPublishEnabled}", description="If true then entries in the queue will be held (not made available for delivery or browsing) until the time (specified in milliseconds since the epoch) given in the message header (AMQP 0-8,0-9,0-9-1,0-10) or message annotation (AMQP 1.0) \"x-qpid-not-valid-before\".  Note that the actual time the entry is made visible may depend on how frequently the virtual host housekeeping thread runs.")
    public boolean isHoldOnPublishEnabled();

    @ManagedAttribute(defaultValue="${queue.defaultMaximumQueueDepthMessages}", description="Maximum number of messages on queue allowed by overflow policy. Negative value indicates that queue depth is unlimited. Default, -1.")
    public long getMaximumQueueDepthMessages();

    @ManagedAttribute(defaultValue="${queue.defaultMaximumQueueDepthBytes}", description="Maximum number of bytes on queue allowed by overflow policy.  Negative value indicates that queue depth is unlimited. Default, -1.")
    public long getMaximumQueueDepthBytes();

    @ManagedAttribute(defaultValue="${queue.defaultOverflowPolicy}", description="Queue overflow policy. Options are ProducerFlowControl, Ring, FlowToDisk, Reject, and None. The policy comes into effect where queue limits described by maximumQueueDepthBytes and/or maximumQueueDepthMessage are breached. ProducerFlowControl - the producing sessions are blocked until queue size falls beneath resume threshold (see context variable queue.queueFlowResumeLimit). Ring - oldest messages are discarded. Reject - incoming messages are rejected. FlowToDisk - new incoming messages are written to disk and immediately evicted from memory. None - queue capacity is unbounded.", mandatory=true)
    public OverflowPolicy getOverflowPolicy();

    @ManagedAttribute(defaultValue="${queue.defaultExpiryPolicy}", description="Queue expiry policy. Options are Delete, and RouteToAlternate. The policy comes into effect where a message on the queue has exceeded its time to live. Delete - the expired message is deleted from the queue. RouteToAlternate - new expired message is routed to the alternate destination for the queue, if present, or deleted if there is no alternate destination.", mandatory=true)
    public ExpiryPolicy getExpiryPolicy();

    @ManagedAttribute(defaultValue="${queue.defaultMaximumLiveConsumers}", description="Maximum live consumers. If the maximum number of live consumers is set to a number greater than zero, then consumers in excess of this limit are held in reserve and will only become eligible to receive messages if a live consumer is removed")
    public int getMaximumLiveConsumers();

    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false, skipAclCheck=true)
    public Collection<PublishingLink> getPublishingLinks();

    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false, skipAclCheck=true)
    public Collection<QueueConsumer<?, ?>> getConsumers();

    public void visit(QueueEntryVisitor var1);

    public CompletableFuture<Integer> deleteAndReturnCountAsync();

    public int deleteAndReturnCount();

    public void setNotificationListener(QueueNotificationListener var1);

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Bindings", description="Current number of bindings to this queue.", metricName="bindings_total")
    public int getBindingCount();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Consumers", description="Current number of consumers attached to this queue.", metricName="consumers_total")
    public int getConsumerCount();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Consumers with credit", description="Current number of consumers attached to this queue with credit", metricName="consumers_with_credit_total")
    public int getConsumerCountWithCredit();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Delivered (Persistent)", description="Total size of all persistent messages delivered by this queue.", resettable=true)
    public long getPersistentDequeuedBytes();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Delivered (Persistent)", description="Total number of persistent messages delivered by this queue.", resettable=true)
    public long getPersistentDequeuedMessages();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Enqueued (Persistent)", description="Total size of all persistent messages received by this queue.", resettable=true)
    public long getPersistentEnqueuedBytes();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Enqueued (Persistent)", description="Total number of persistent messages received by this queue.", resettable=true)
    public long getPersistentEnqueuedMessages();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Queue Depth", description="Current size of all messages enqueued by this queue.", metricName="depth_bytes_total")
    public long getQueueDepthBytes();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Queue Depth", description="Current number of messages enqueued by this queue.", metricName="depth_messages_total")
    public int getQueueDepthMessages();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Delivered", description="Total size of all messages delivered by this queue.", metricName="dequeued_bytes_count", resettable=true)
    public long getTotalDequeuedBytes();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Delivered", description="Total number of messages delivered by this queue.", metricName="dequeued_messages_count", resettable=true)
    public long getTotalDequeuedMessages();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Enqueued", description="Total size of all messages received by this queue.", metricName="enqueue_bytes_count", resettable=true)
    public long getTotalEnqueuedBytes();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Enqueued", description="Total number of messages received by this queue.", metricName="enqueued_messages_count", resettable=true)
    public long getTotalEnqueuedMessages();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Expired", description="Total size of all messages expired by message time-to-live on this queue.", metricName="expired_bytes_count", resettable=true)
    public long getTotalExpiredBytes();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Expired", description="Total number of messages expired by message time-to-live on this queue.", metricName="expired_messages_count", resettable=true)
    public long getTotalExpiredMessages();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Prefetched", description="Total size of all messages currently prefetched by consumers.")
    public long getUnacknowledgedBytes();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Prefetched", description="Total number of messages currently prefetched by consumers.")
    public long getUnacknowledgedMessages();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Available", description="Total size of all messages currently available.")
    public long getAvailableBytes();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Available", description="Total number of messages currently available.")
    public int getAvailableMessages();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Available HWM", description="Maximum recorded size of available messages.", metricName="available_bytes_high_water_mark", resettable=true)
    public long getAvailableBytesHighWatermark();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Available HWM", description="Maximum recorded number of available messages.", metricName="available_messages_high_water_mark", resettable=true)
    public int getAvailableMessagesHighWatermark();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES, label="Queue Depth HWM", description="Maximum recorded size of enqueued messages.", metricName="depth_bytes_high_water_mark", resettable=true)
    public long getQueueDepthBytesHighWatermark();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES, label="Queue Depth HWM", description="Maximum recorded number of enqueued messages.", metricName="depth_messages_high_water_mark", resettable=true)
    public int getQueueDepthMessagesHighWatermark();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.TIME_DURATION, label="Oldest Message", description="Current age of oldest message on the queue.", metricName="oldest_message_age_milliseconds")
    public long getOldestMessageAge();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.BYTES, label="Malformed", description="Total size of enqueued malformed messages.", metricName="malformed_bytes_count", resettable=true)
    public long getTotalMalformedBytes();

    @ManagedStatistic(statisticType=StatisticType.CUMULATIVE, units=StatisticUnit.MESSAGES, label="Malformed", description="Total number of enqueued malformed messages.", metricName="malformed_messages_count", resettable=true)
    public long getTotalMalformedMessages();

    @ManagedOperation(description="Resets queue statistics", changesConfiguredObjectState=true)
    public void resetStatistics();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.COUNT, label="Producers", description="Number of producers to this queue.", metricName="producers_count")
    public long getProducerCount();

    @ManagedOperation(description="move messages from this queue to another", changesConfiguredObjectState=false)
    public List<Long> moveMessages(@Param(name="destination", description="The queue to which the messages should be moved", mandatory=true) Queue<?> var1, @Param(name="messageIds", description="If provided, only messages in the queue whose (internal) message-id is supplied will be considered for moving") List<Long> var2, @Param(name="selector", description="A (JMS) selector - if provided, only messages which match the selector will be considered for moving") String var3, @Param(name="limit", description="Maximum number of messages to move", defaultValue="-1") int var4);

    @ManagedOperation(description="copies messages from this queue to another", changesConfiguredObjectState=false)
    public List<Long> copyMessages(@Param(name="destination", description="The queue to which the messages should be copied", mandatory=true) Queue<?> var1, @Param(name="messageIds", description="If provided, only messages in the queue whose (internal) message-id is supplied will be considered for copying") List<Long> var2, @Param(name="selector", description="A (JMS) selector - if provided, only messages which match the selector will be considered for copying") String var3, @Param(name="limit", description="Maximum number of messages to copy", defaultValue="-1") int var4);

    @ManagedOperation(description="removes messages from this queue", changesConfiguredObjectState=false)
    public List<Long> deleteMessages(@Param(name="messageIds", description="If provided, only messages in the queue whose (internal) message-id is supplied will be considered for deletion") List<Long> var1, @Param(name="selector", description="A (JMS) selector - if provided, only messages which match the selector will be considered for deletion") String var2, @Param(name="limit", description="Maximum number of messages to delete", defaultValue="-1") int var3);

    @ManagedOperation(description="removes all messages from this queue", changesConfiguredObjectState=false)
    public long clearQueue();

    @ManagedOperation(nonModifying=true, secure=true, changesConfiguredObjectState=false, description="Gets the message content")
    public Content getMessageContent(@Param(name="messageId") long var1, @Param(name="limit", defaultValue="-1", description="Number of bytes to return") long var3, @Param(name="returnJson", defaultValue="false", description="If true, converts message content into JSON format. If false, returned bytes may be in an encoded form") boolean var5, @Param(name="decompressBeforeLimiting", defaultValue="false", description="If true, the operation will attempt to decompress the message(should it be compressed) before applying any limit. Ifdecompression fails the operation will fail.") boolean var6);

    @ManagedOperation(description="get information about a range of messages", nonModifying=true, paramRequiringSecure="includeHeaders", changesConfiguredObjectState=false)
    public List<MessageInfo> getMessageInfo(@Param(name="first", defaultValue="-1") int var1, @Param(name="last", defaultValue="-1") int var2, @Param(name="includeHeaders", defaultValue="false") boolean var3);

    @ManagedOperation(description="get information about the message with the given Id", nonModifying=true, paramRequiringSecure="includeHeaders", changesConfiguredObjectState=false)
    public MessageInfo getMessageInfoById(@Param(name="messageId") long var1, @Param(name="includeHeaders", defaultValue="true") boolean var3);

    public boolean isExclusive();

    public LogSubject getLogSubject();

    public QueueManagingVirtualHost<?> getVirtualHost();

    public boolean isUnused();

    public boolean isEmpty();

    public long getOldestMessageArrivalTime();

    public void requeue(QueueEntry var1);

    public List<? extends QueueEntry> getMessagesOnTheQueue();

    public QueueEntry getMessageOnTheQueue(long var1);

    public void checkMessageStatus();

    public void reallocateMessages();

    public Set<NotificationCheck> getNotificationChecks();

    public Collection<String> getAvailableAttributes();

    public void completeRecovery();

    public void recover(ServerMessage<?> var1, MessageEnqueueRecord var2);

    public boolean isHeld(QueueEntry var1, long var2);

    public void checkCapacity();

    public void deleteEntry(QueueEntry var1);

    public QueueEntry getLeastSignificantOldestEntry();

    public QueueEntryIterator queueEntryIterator();

    public boolean checkValid(QueueEntry var1);

    public static enum BehaviourOnUnknownDeclareArgument {
        IGNORE,
        LOG,
        FAIL;

    }

    public static enum ExpiryPolicy {
        DELETE,
        ROUTE_TO_ALTERNATE;

    }
}

