/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util.urlstreamhandler.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.qpid.server.util.Strings;

public class Handler
extends URLStreamHandler {
    public static final String PROTOCOL_HANDLER_PROPERTY = "java.protocol.handler.pkgs";
    private static boolean _registered;

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new DataUrlConnection(u);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register() {
        Properties properties = System.getProperties();
        synchronized (properties) {
            if (!_registered) {
                String registeredPackages = System.getProperty(PROTOCOL_HANDLER_PROPERTY);
                String thisPackage = Handler.class.getPackage().getName();
                String packageToRegister = thisPackage.substring(0, thisPackage.lastIndexOf(46));
                System.setProperty(PROTOCOL_HANDLER_PROPERTY, (String)(registeredPackages == null ? packageToRegister : packageToRegister + "|" + registeredPackages));
                _registered = true;
            }
        }
    }

    private static class DataUrlConnection
    extends URLConnection {
        private final byte[] _content;
        private final String _contentType;
        private final boolean _base64;

        public DataUrlConnection(URL u) throws IOException {
            super(u);
            String[] parts;
            String externalForm = u.toExternalForm();
            if (externalForm.startsWith("data:")) {
                parts = externalForm.substring(5).split(",", 2);
                this._base64 = parts[0].endsWith(";base64");
                if (this._base64) {
                    this._content = Strings.decodeBase64(parts[1]);
                } else {
                    try {
                        this._content = URLDecoder.decode(parts[1], StandardCharsets.US_ASCII.name()).getBytes(StandardCharsets.US_ASCII);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IOException(e);
                    }
                }
            } else {
                throw new MalformedURLException("'" + externalForm + "' does not start with 'data:'");
            }
            String mediaType = (this._base64 ? parts[0].substring(0, parts[0].length() - ";base64".length()) : parts[0]).split(";")[0];
            this._contentType = "".equals(mediaType) ? "text/plain" : mediaType;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public int getContentLength() {
            return this._content.length;
        }

        @Override
        public String getContentType() {
            return this._contentType;
        }

        @Override
        public String getContentEncoding() {
            return this._base64 ? "base64" : null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this._content);
        }
    }
}

