/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredValueSet;
import com.sleepycat.je.Database;
import java.util.Comparator;
import java.util.SortedSet;

public class StoredSortedValueSet<E>
extends StoredValueSet<E>
implements SortedSet<E> {
    public StoredSortedValueSet(Database database, EntityBinding<E> valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, null, null, valueEntityBinding, writeAllowed, null));
        this.checkKeyDerivation();
    }

    StoredSortedValueSet(DataView valueSetView) {
        super(valueSetView);
        this.checkKeyDerivation();
    }

    private void checkKeyDerivation() {
        if (!this.view.canDeriveKeyFromValue()) {
            throw new IllegalArgumentException("Cannot derive key from value");
        }
    }

    @Override
    public Comparator<? super E> comparator() {
        return null;
    }

    @Override
    public E first() {
        return this.getFirstOrLast(true);
    }

    @Override
    public E last() {
        return this.getFirstOrLast(false);
    }

    @Override
    public SortedSet<E> headSet(E toValue) {
        return this.subSet(null, false, toValue, false);
    }

    public SortedSet<E> headSet(E toValue, boolean toInclusive) {
        return this.subSet(null, false, toValue, toInclusive);
    }

    @Override
    public SortedSet<E> tailSet(E fromValue) {
        return this.subSet(fromValue, true, null, false);
    }

    public SortedSet<E> tailSet(E fromValue, boolean fromInclusive) {
        return this.subSet(fromValue, fromInclusive, null, false);
    }

    @Override
    public SortedSet<E> subSet(E fromValue, E toValue) {
        return this.subSet(fromValue, true, toValue, false);
    }

    public SortedSet<E> subSet(E fromValue, boolean fromInclusive, E toValue, boolean toInclusive) {
        try {
            return new StoredSortedValueSet<E>(this.view.subView(fromValue, fromInclusive, toValue, toInclusive, null));
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }
}

