/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.validation;

import java.util.Objects;
import org.apache.qpid.server.query.engine.exception.QueryValidationException;
import org.apache.qpid.server.query.engine.parsing.expression.set.SetExpression;
import org.apache.qpid.server.query.engine.parsing.query.QueryExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;
import org.apache.qpid.server.query.engine.validation.SelectExpressionValidator;

public class QueryExpressionValidator {
    private final SelectExpressionValidator _selectExpressionValidator = new SelectExpressionValidator();

    public <T, R> void validate(QueryExpression<T, R> query) {
        Objects.requireNonNull(query, "Query expression must be not null");
        SetExpression<T, R> setExpression = query.getSelect();
        if (setExpression == null) {
            throw QueryValidationException.of("Missing expression", new Object[0]);
        }
        if (setExpression instanceof SelectExpression) {
            SelectExpression selectExpression = (SelectExpression)setExpression;
            this._selectExpressionValidator.validate(selectExpression);
        }
    }
}

