/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.sqlmm.FunctionWithSRID;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class GeometryConstructor<R, G>
extends FunctionWithSRID<R> {
    private static final long serialVersionUID = -4644842662358995787L;
    final Expression<R, ?> geometry;
    final Geometries<G> library;

    GeometryConstructor(SQLMM operation, Expression<R, ?>[] parameters, Geometries<G> library) {
        super(operation, parameters, parameters.length >= operation.maxParamCount ? 1 : 0);
        this.geometry = parameters[0];
        this.library = library;
    }

    @Override
    public Expression<R, Object> recreate(Expression<R, ?>[] effective) {
        return new GeometryConstructor(this.operation, effective, this.getGeometryLibrary());
    }

    @Override
    public Class<? super R> getResourceClass() {
        return GeometryConstructor.specializedClass(this.geometry.getResourceClass(), super.getResourceClass());
    }

    @Override
    public final List<Expression<R, ?>> getParameters() {
        return this.srid != null ? List.of(this.geometry, this.srid) : List.of(this.geometry);
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return this.library;
    }

    @Override
    public Object apply(R input) {
        Object value = this.geometry.apply(input);
        try {
            CoordinateReferenceSystem crs;
            if (value == null) {
                return null;
            }
            GeometryWrapper result = value instanceof byte[] ? this.library.parseWKB(ByteBuffer.wrap((byte[])value)) : (value instanceof ByteBuffer ? this.library.parseWKB((ByteBuffer)value) : (value instanceof String ? this.library.parseWKT((String)value) : this.library.createFromComponents(this.operation.getGeometryType().get(), value)));
            Object geomImpl = this.library.getGeometry(result);
            Class<?> expected = this.operation.getReturnType(this.library);
            if (!expected.isInstance(geomImpl)) {
                throw new IllegalArgumentException(Errors.format((short)58, (Object)"geom", expected, (Object)Classes.getClass((Object)geomImpl)));
            }
            if (this.srid != null && (crs = this.getTargetCRS(input)) != null) {
                result.setCoordinateReferenceSystem(crs);
            }
            return geomImpl;
        }
        catch (Exception e) {
            this.warning(e);
            return null;
        }
    }
}

