/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.validation;

import java.util.regex.Pattern;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.EncoderConstants;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.reference.validation.BaseValidationRule;
import org.owasp.esapi.reference.validation.StringValidationRule;

public class CreditCardValidationRule
extends BaseValidationRule {
    private int maxCardLength = 19;
    protected static final String CREDIT_CARD_VALIDATOR_KEY = "CreditCard";
    private StringValidationRule ccrule = null;

    public CreditCardValidationRule(String typeName, Encoder encoder) {
        super(typeName, encoder);
        this.ccrule = this.readDefaultCreditCardRule();
    }

    public CreditCardValidationRule(String typeName, Encoder encoder, StringValidationRule validationRule) {
        super(typeName, encoder);
        this.ccrule = validationRule;
    }

    private StringValidationRule readDefaultCreditCardRule() {
        Pattern p = ESAPI.securityConfiguration().getValidationPattern(CREDIT_CARD_VALIDATOR_KEY);
        StringValidationRule ccr = new StringValidationRule("ccrule", this.encoder, p.pattern());
        ccr.setMaximumLength(this.getMaxCardLength());
        ccr.setAllowNull(false);
        return ccr;
    }

    @Override
    public String getValid(String context, String input) throws ValidationException {
        if (StringUtilities.isEmpty(input)) {
            if (this.allowNull) {
                return null;
            }
            throw new ValidationException(context + ": Input credit card required", "Input credit card required: context=" + context + ", input=" + input, context);
        }
        String canonical = this.ccrule.getValid(context, input);
        if (!this.validCreditCardFormat(canonical)) {
            throw new ValidationException(context + ": Invalid credit card input", "Invalid credit card input: context=" + context, context);
        }
        return canonical;
    }

    protected boolean validCreditCardFormat(String ccNum) {
        StringBuilder digitsOnly = new StringBuilder();
        for (int i = 0; i < ccNum.length(); ++i) {
            char c = ccNum.charAt(i);
            if (!Character.isDigit(c)) continue;
            digitsOnly.append(c);
        }
        int sum = 0;
        int digit = 0;
        int addend = 0;
        boolean timesTwo = false;
        for (int i = digitsOnly.length() - 1; i >= 0; --i) {
            digit = Integer.valueOf(digitsOnly.substring(i, i + 1));
            if (timesTwo) {
                addend = digit * 2;
                if (addend > 9) {
                    addend -= 9;
                }
            } else {
                addend = digit;
            }
            sum += addend;
            timesTwo = !timesTwo;
        }
        return sum % 10 == 0;
    }

    @Override
    public String sanitize(String context, String input) {
        return this.whitelist(input, EncoderConstants.CHAR_DIGITS);
    }

    public void setStringValidatorRule(StringValidationRule ccrule) {
        this.ccrule = ccrule;
    }

    public StringValidationRule getStringValidatorRule() {
        return this.ccrule;
    }

    public void setMaxCardLength(int maxCardLength) {
        this.maxCardLength = maxCardLength;
    }

    public int getMaxCardLength() {
        return this.maxCardLength;
    }
}

