/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.util.function.Function;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.ObjectUtils;

public final class Validate {
    private Validate() {
    }

    public static <T> T notNull(T object) {
        return Validate.notNull(object, "The validated object is null", new Object[0]);
    }

    public static <T> T notNull(T object, String message, Object ... values) {
        return Validate.notNull(object, NullPointerException::new, message, values);
    }

    public static <E extends Exception, T> T notNull(T object, Function<? super String, ? extends E> fn, String message, Object ... values) throws E {
        Exceptions.raiseIf(object == null, fn, message, values);
        return object;
    }

    public static void isTrue(boolean expression, String message, Object ... values) {
        Exceptions.raiseUnless(expression, IllegalArgumentException::new, message, values);
    }

    public static <T> T[] noNullElements(T[] array, String message, Object ... values) {
        Validate.notNull(array);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            Exceptions.raise(IllegalArgumentException::new, message, ObjectUtils.arrayAdd(values, i));
        }
        return array;
    }

    public static void validState(boolean expression, String message, Object ... values) {
        Exceptions.raiseUnless(expression, IllegalStateException::new, message, values);
    }
}

