/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.Session;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class TailCommandSupport
implements Action {
    @Reference
    Session session;
    @Reference
    BundleContext bundleContext;

    public abstract int[] getColumnSizes();

    public abstract String[] getColumnHeaders();

    public void outputHeaders(PrintStream out) {
        StringBuilder headerLine = new StringBuilder();
        int[] columnSizes = this.getColumnSizes();
        String[] columnHeaders = this.getColumnHeaders();
        for (int i = 0; i < columnSizes.length; ++i) {
            headerLine.append(this.getColumn(columnSizes[i], columnHeaders[i]));
            headerLine.append("|");
        }
        out.println(headerLine.toString());
        out.println(StringUtils.repeat((String)"-", (int)headerLine.length()));
    }

    public String getColumn(int columnSize, String columnContent) {
        if (columnContent == null) {
            columnContent = "null";
        }
        if (columnContent.length() == columnSize) {
            return columnContent;
        }
        if (columnContent.length() < columnSize) {
            return columnContent + StringUtils.repeat((String)" ", (int)(columnSize - columnContent.length()));
        }
        return columnContent.substring(0, columnSize);
    }

    public void outputLine(PrintStream out, List<String> eventInfo) {
        StringBuilder eventLine = new StringBuilder();
        int[] columnSizes = this.getColumnSizes();
        for (int i = 0; i < columnSizes.length; ++i) {
            eventLine.append(this.getColumn(columnSizes[i], eventInfo.get(i)));
            eventLine.append("|");
        }
        out.println(eventLine.toString());
    }

    public abstract Object getListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        PrintStream out = this.session.getConsole();
        out.flush();
        this.outputHeaders(out);
        Object listener = this.getListener();
        ArrayList<String> interfaces = new ArrayList<String>();
        for (Class<?> listenerInterface : listener.getClass().getInterfaces()) {
            interfaces.add(listenerInterface.getName());
        }
        ServiceRegistration tailServiceRegistration = this.bundleContext.registerService(interfaces.toArray(new String[interfaces.size()]), listener, new Hashtable());
        try {
            TailCommandSupport tailCommandSupport = this;
            synchronized (tailCommandSupport) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            tailServiceRegistration.unregister();
        }
        return null;
    }
}

