/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.util.lang.Args;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public abstract class AjaxFormChoiceComponentUpdatingBehavior
extends AjaxFormComponentUpdatingBehavior {
    private static final long serialVersionUID = 1L;

    public AjaxFormChoiceComponentUpdatingBehavior() {
        super("change");
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.setSerializeRecursively(true);
        attributes.getAjaxCallListeners().add(new AjaxCallListener(){
            private static final long serialVersionUID = 1L;

            @Override
            public CharSequence getPrecondition(Component component) {
                return String.format("return attrs.event.target.name === '%s'", AjaxFormChoiceComponentUpdatingBehavior.this.getFormComponent().getInputName());
            }
        });
    }

    @Override
    protected void onBind() {
        super.onBind();
        if (this.getComponent() instanceof RadioGroup || this.getComponent() instanceof CheckGroup) {
            this.getComponent().setRenderBodyOnly(false);
        }
    }

    @Override
    protected void checkComponent(FormComponent<?> component) {
        if (!AjaxFormChoiceComponentUpdatingBehavior.appliesTo(this.getComponent())) {
            throw new WicketRuntimeException("Behavior " + this.getClass().getName() + " can only be added to an instance of a RadioChoice/CheckboxChoice/RadioGroup/CheckGroup");
        }
    }

    static boolean appliesTo(Component component) {
        return component instanceof RadioChoice || component instanceof CheckBoxMultipleChoice || component instanceof RadioGroup || component instanceof CheckGroup;
    }

    public static AjaxFormChoiceComponentUpdatingBehavior onUpdateChoice(final SerializableConsumer<AjaxRequestTarget> onUpdateChoice) {
        Args.notNull(onUpdateChoice, "onUpdateChoice");
        return new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onUpdate(AjaxRequestTarget target) {
                onUpdateChoice.accept(target);
            }
        };
    }
}

