/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.PerfSupport;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.results.ScalarDerivativeResult;
import org.openjdk.jmh.util.ScoreFormatter;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfProfiler
implements ExternalProfiler {
    private final boolean isDelayed;
    private final int delayMs;
    private final List<String> events;

    public LinuxPerfProfiler(String initLine) throws ProfilerException {
        OptionParser parser = new OptionParser();
        parser.formatHelpWith(new ProfilerOptionFormatter("perf"));
        ArgumentAcceptingOptionSpec<Integer> optDelay = parser.accepts("delay", "Delay collection for a given time, in milliseconds; -1 to detect automatically.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo(-1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<String> optEvents = parser.accepts("events", "Events to gather.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",").describedAs("event");
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.events = set.valuesOf(optEvents);
            this.delayMs = set.valueOf(optDelay);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
        Collection<String> msgs = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "echo", "1");
        if (!msgs.isEmpty()) {
            throw new ProfilerException(msgs.toString());
        }
        Collection<String> delay = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--delay", "1", "echo", "1");
        this.isDelayed = delay.isEmpty();
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        long delay = this.delayMs == -1 ? TimeUnit.NANOSECONDS.toMillis((long)params.getWarmup().getCount() * params.getWarmup().getTime().convertTo(TimeUnit.NANOSECONDS)) + TimeUnit.SECONDS.toMillis(1L) : (long)this.delayMs;
        ArrayList<String> invokeOptions = new ArrayList<String>(Arrays.asList(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--detailed", "--detailed", "--detailed"));
        if (this.isDelayed) {
            invokeOptions.add("--delay");
            invokeOptions.add(String.valueOf(delay));
        }
        if (!this.events.isEmpty()) {
            invokeOptions.add("-e");
            invokeOptions.add(Utils.join(this.events, ","));
        }
        return invokeOptions;
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        PerfResult result = this.process(stdOut, stdErr);
        return Collections.singleton(result);
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Linux perf Statistics";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private PerfResult process(File stdOut, File stdErr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Pattern hashLinePattern = Pattern.compile("(.*)#(.*)");
        try (FileReader fr = new FileReader(stdErr);){
            PerfResult perfResult;
            try (BufferedReader reader = new BufferedReader(fr);){
                String line;
                long cycles = 0L;
                long insns = 0L;
                boolean printing = false;
                while ((line = reader.readLine()) != null) {
                    Matcher m;
                    if (printing) {
                        pw.println(line);
                    }
                    if (line.contains("Performance counter stats")) {
                        printing = true;
                    }
                    if (!(m = hashLinePattern.matcher(line)).matches()) continue;
                    String pair = m.group(1).trim();
                    if (pair.contains(" cycles")) {
                        try {
                            cycles = NumberFormat.getInstance().parse(pair.split("[ ]+")[0]).longValue();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (!line.contains(" instructions")) continue;
                    try {
                        insns = NumberFormat.getInstance().parse(pair.split("[ ]+")[0]).longValue();
                    }
                    catch (ParseException parseException) {}
                }
                if (!this.isDelayed) {
                    pw.println();
                    pw.println("WARNING: Your system uses old \"perf\", which can not delay data collection.\nTherefore, perf performance data includes benchmark warmup.");
                }
                pw.flush();
                pw.close();
                perfResult = new PerfResult(sw.toString(), cycles, insns);
            }
            return perfResult;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static class PerfResult
    extends Result<PerfResult> {
        private static final long serialVersionUID = -1262685915873231436L;
        private final String output;
        private final long cycles;
        private final long instructions;

        public PerfResult(String output, long cycles, long instructions) {
            super(ResultRole.SECONDARY, "perf", PerfResult.of(Double.NaN), "---", AggregationPolicy.AVG);
            this.output = output;
            this.cycles = cycles;
            this.instructions = instructions;
        }

        @Override
        protected Aggregator<PerfResult> getThreadAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Aggregator<PerfResult> getIterationAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Collection<? extends Result> getDerivativeResults() {
            ArrayList<ScalarDerivativeResult> res = new ArrayList<ScalarDerivativeResult>();
            if (this.cycles != 0L && this.instructions != 0L) {
                res.add(new ScalarDerivativeResult("ipc", 1.0 * (double)this.instructions / (double)this.cycles, "insns/clk", AggregationPolicy.AVG));
                res.add(new ScalarDerivativeResult("cpi", 1.0 * (double)this.cycles / (double)this.instructions, "clks/insn", AggregationPolicy.AVG));
            }
            return res;
        }

        @Override
        public String toString() {
            if (this.cycles != 0L && this.instructions != 0L) {
                return String.format("%s IPC, %s CPI", ScoreFormatter.format(1.0 * (double)this.instructions / (double)this.cycles), ScoreFormatter.format(1.0 * (double)this.cycles / (double)this.instructions));
            }
            return "N/A";
        }

        @Override
        public String extendedInfo() {
            return "Perf stats:\n--------------------------------------------------\n" + this.output;
        }
    }

    static class PerfResultAggregator
    implements Aggregator<PerfResult> {
        PerfResultAggregator() {
        }

        @Override
        public PerfResult aggregate(Collection<PerfResult> results) {
            long cycles = 0L;
            long instructions = 0L;
            String output = "";
            for (PerfResult r : results) {
                cycles += r.cycles;
                instructions += r.instructions;
                output = output + r.output;
            }
            return new PerfResult(output, cycles, instructions);
        }
    }
}

