/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.template.parser;

import java.util.Objects;
import org.apache.cayenne.template.Context;
import org.apache.cayenne.template.parser.ASTMethod;
import org.apache.cayenne.template.parser.ExpressionNode;
import org.apache.cayenne.template.parser.IdentifierNode;

public class ASTVariable
extends IdentifierNode
implements ExpressionNode {
    public ASTVariable(int id) {
        super(id);
    }

    @Override
    public String evaluateAsString(Context context) {
        Object object = this.evaluateAsObject(context);
        if (object == null) {
            if (!context.haveObject(this.getIdentifier())) {
                return '$' + this.getIdentifier();
            }
            return "";
        }
        return object.toString();
    }

    @Override
    public Object evaluateAsObject(Context context) {
        Object object = context.getObject(this.getIdentifier());
        if (object == null) {
            return null;
        }
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ASTMethod method = (ASTMethod)this.jjtGetChild(i);
            object = method.evaluateAsObject(context, object);
            if (object != null) continue;
            return null;
        }
        return object;
    }

    @Override
    public void evaluate(Context context) {
        context.getBuilder().append(this.evaluateAsString(context));
    }

    @Override
    public long evaluateAsLong(Context context) {
        Number object = (Number)Objects.requireNonNull(this.evaluateAsObject(context));
        return object.longValue();
    }

    @Override
    public double evaluateAsDouble(Context context) {
        Number object = (Number)Objects.requireNonNull(this.evaluateAsObject(context));
        return object.doubleValue();
    }

    @Override
    public boolean evaluateAsBoolean(Context context) {
        Object object = this.evaluateAsObject(context);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return object != null;
    }
}

