/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.PerCatalogAndSchemaLoader;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.SchemaFilter;
import org.apache.cayenne.map.Procedure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureLoader
extends PerCatalogAndSchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLoader.class);

    ProcedureLoader(DbAdapter adapter, DbLoaderConfiguration config, DbLoaderDelegate delegate) {
        super(adapter, config, delegate);
    }

    @Override
    protected ResultSet getResultSet(String catalogName, String schemaName, DatabaseMetaData metaData) throws SQLException {
        return metaData.getProcedures(catalogName, schemaName, "%");
    }

    @Override
    protected boolean shouldLoad(CatalogFilter catalog, SchemaFilter schema) {
        PatternFilter filter = this.config.getFiltersConfig().proceduresFilter(catalog.name, schema.name);
        return !filter.isEmpty();
    }

    @Override
    protected void processResultSetRow(CatalogFilter catalog, SchemaFilter schema, DbLoadDataStore map, ResultSet rs) throws SQLException {
        String name;
        PatternFilter filter = this.config.getFiltersConfig().proceduresFilter(catalog.name, schema.name);
        if (!filter.isIncluded(name = rs.getString("PROCEDURE_NAME"))) {
            LOGGER.info("skipping Cayenne PK procedure: " + name);
            return;
        }
        Procedure procedure = new Procedure(name);
        procedure.setCatalog(rs.getString("PROCEDURE_CAT"));
        procedure.setSchema(rs.getString("PROCEDURE_SCHEM"));
        switch (rs.getShort("PROCEDURE_TYPE")) {
            case 0: 
            case 1: {
                procedure.setReturningValue(false);
                break;
            }
            case 2: {
                procedure.setReturningValue(true);
            }
        }
        map.addProcedureSafe(procedure);
    }
}

