/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import org.apache.cayenne.modeler.action.FindAction;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.swing.ImageRendererColumn;
import org.apache.cayenne.swing.components.TopBorder;

public class FindDialogView
extends JDialog {
    private JButton okButton;
    private JTable table;
    private int index;

    public JTable getTable() {
        return this.table;
    }

    public FindDialogView(List<FindAction.SearchResultEntry> searchResults) {
        super((Frame)null, "Search results", true);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new BoxLayout(panel, 1));
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        tableModel.setDataVector(this.convertToDataVector(searchResults), new Object[]{""});
        this.table = new JTable(tableModel);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new ImageRendererColumn());
        this.table.setSelectionMode(0);
        InputMap im = this.table.getInputMap(1);
        InputMap imParent = im.getParent();
        imParent.remove(KeyStroke.getKeyStroke(10, 0));
        im.setParent(imParent);
        im.remove(KeyStroke.getKeyStroke(10, 0));
        this.table.setInputMap(1, im);
        JPanel okPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton("OK");
        this.getRootPane().setDefaultButton(this.okButton);
        okPanel.setBorder(TopBorder.create());
        okPanel.add(this.okButton);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.table, 20, 30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        contentPane.add(scrollPane);
        contentPane.add((Component)okPanel, "South");
        contentPane.setPreferredSize(new Dimension(400, 325));
    }

    private JLabel[][] convertToDataVector(List<FindAction.SearchResultEntry> resultEntries) {
        JLabel[][] dataVector = new JLabel[resultEntries.size()][1];
        for (FindAction.SearchResultEntry entry : resultEntries) {
            JLabel labelIcon = new JLabel();
            labelIcon.setIcon(CellRenderers.iconForObject(entry.getObject()));
            labelIcon.setText(entry.getName());
            dataVector[this.index++] = new JLabel[]{labelIcon};
        }
        return dataVector;
    }

    public JButton getOkButton() {
        return this.okButton;
    }
}

