/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDirectCompactItemsSketch;
import org.apache.datasketches.kll.KllHeapItemsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllItemsHelper;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.ItemsSketchSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscItemsTest {
    public ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
    private static final boolean enablePrinting = false;

    @Test
    public void checkSortedViewConstruction() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 20;
        int digits = Util.numDigits((long)20L);
        for (int i = 1; i <= 20; ++i) {
            sk.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
        }
        ItemsSketchSortedView sv = sk.getSortedView();
        long[] cumWeights = sv.getCumulativeWeights();
        String[] values = (String[])sv.getQuantiles();
        Assert.assertEquals((int)cumWeights.length, (int)20);
        Assert.assertEquals((int)values.length, (int)20);
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((long)cumWeights[i], (long)(i + 1));
            Assert.assertEquals((String)values[i], (String)Util.longToFixedLengthString((long)(i + 1), (int)digits));
        }
    }

    @Test
    public void checkBounds() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 1000;
        int digits = Util.numDigits((long)1000L);
        for (int i = 1; i <= 1000; ++i) {
            sk.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
        }
        double eps = sk.getNormalizedRankError(false);
        String est = (String)sk.getQuantile(0.5);
        String ub = (String)sk.getQuantileUpperBound(0.5);
        String lb = (String)sk.getQuantileLowerBound(0.5);
        Assert.assertEquals((String)ub, (String)((String)sk.getQuantile(0.5 + eps)));
        Assert.assertEquals((String)lb, (String)((String)sk.getQuantile(0.5 - eps)));
        KllMiscItemsTest.println("Ext     : " + est);
        KllMiscItemsTest.println("UB      : " + ub);
        KllMiscItemsTest.println("LB      : " + lb);
        double rest = sk.getRank((Object)est);
        double restUB = sk.getRankUpperBound(rest);
        double restLB = sk.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions1() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        wseg.set(ValueLayout.JAVA_BYTE, 6L, (byte)3);
        KllItemsSketch.heapify((MemorySegment)wseg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions2() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        wseg.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        KllItemsSketch.heapify((MemorySegment)wseg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions3() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        sk.update((Object)"2");
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        wseg.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        KllItemsSketch.heapify((MemorySegment)wseg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions4() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        wseg.set(ValueLayout.JAVA_BYTE, 1L, (byte)0);
        KllItemsSketch.heapify((MemorySegment)wseg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions5() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        wseg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        KllItemsSketch.heapify((MemorySegment)wseg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test
    public void checkMisc() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        int n = 21;
        int digits = Util.numDigits((long)21L);
        for (int i = 1; i <= 21; ++i) {
            sk.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        sk.toByteArray();
        String[] items = (String[])sk.getTotalItemsArray();
        Assert.assertEquals((int)items.length, (int)33);
        int[] levels = sk.getLevelsArray(sk.sketchStructure);
        Assert.assertEquals((int)levels.length, (int)3);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
    }

    public void visualCheckToString() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 21;
        int digits = 3;
        for (int i = 1; i <= n; ++i) {
            sk.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((String)((String)sk.getMinItem()), (String)"  1");
        Assert.assertEquals((String)((String)sk.getMaxItem()), (String)" 21");
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        KllItemsSketch sk2 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        n = 400;
        digits = 3;
        for (int i = 101; i <= n + 100; ++i) {
            sk2.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
        }
        KllMiscItemsTest.println(Util.LS + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((String)((String)sk2.getMinItem()), (String)"101");
        Assert.assertEquals((String)((String)sk2.getMaxItem()), (String)"500");
        Assert.assertEquals((int)sk2.getNumRetained(), (int)52);
        sk2.merge((KllSketch)sk);
        KllMiscItemsTest.println(Util.LS + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((String)((String)sk2.getMinItem()), (String)"  1");
        Assert.assertEquals((String)((String)sk2.getMaxItem()), (String)"500");
        Assert.assertEquals((int)sk2.getNumRetained(), (int)56);
    }

    @Test
    public void viewHeapCompactions() {
        int k = 20;
        int n = 108;
        boolean withLevels = false;
        boolean withLevelsAndItems = true;
        int digits = Util.numDigits((long)108L);
        int compaction = 0;
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= 108; ++i) {
            sk.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
            if (sk.levelsArr[0] != 0) continue;
            KllMiscItemsTest.println(Util.LS + "#<<< BEFORE COMPACTION # " + ++compaction + " >>>");
            KllMiscItemsTest.println(sk.toString(true, true));
            sk.update((Object)Util.longToFixedLengthString((long)(++i), (int)digits));
            KllMiscItemsTest.println(Util.LS + "#<<< AFTER COMPACTION  # " + compaction + " >>>");
            KllMiscItemsTest.println(sk.toString(true, true));
            Assert.assertEquals((String)((String[])sk.getTotalItemsArray())[sk.levelsArr[0]], (String)Util.longToFixedLengthString((long)i, (int)digits));
        }
        KllMiscItemsTest.println(Util.LS + "#<<< END STATE # >>>");
        KllMiscItemsTest.println(sk.toString(false, true));
        KllMiscItemsTest.println("");
    }

    @Test
    public void viewCompactionAndSortedView() {
        int n = 43;
        int digits = Util.numDigits((long)43L);
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= 43; ++i) {
            sk.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        ItemsSketchSortedView sv = sk.getSortedView();
        GenericSortedViewIterator itr = sv.iterator();
        KllMiscItemsTest.println("### SORTED VIEW");
        KllMiscItemsTest.printf("%6s %12s %12s" + Util.LS, "Idx", "Value", "CumWeight");
        int i = 0;
        while (itr.next()) {
            String v = (String)itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscItemsTest.printf("%6d %12s %12d" + Util.LS, i, v, wt);
            ++i;
        }
        Assert.assertEquals((String)((String)sv.getMinItem()), (String)" 1");
        Assert.assertEquals((String)((String)sv.getMaxItem()), (String)Integer.toString(43));
    }

    @Test
    public void checkWeightedUpdates1() {
        int k = 20;
        int weight = 127;
        String item = "10";
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println(sk.toString(true, true));
        sk.update((Object)"10", 127L);
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumRetained(), (int)7);
        Assert.assertEquals((long)sk.getN(), (long)127L);
        sk.update((Object)"10", 127L);
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumRetained(), (int)14);
        Assert.assertEquals((long)sk.getN(), (long)254L);
    }

    @Test
    public void checkWeightedUpdates2() {
        int k = 20;
        int initial = 1000;
        int digits = 4;
        int weight = 127;
        String item = "  10";
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= 1000; ++i) {
            sk.update((Object)Util.longToFixedLengthString((long)(i + 1000), (int)4));
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        sk.update((Object)"  10", 127L);
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumRetained(), (int)65);
        Assert.assertEquals((long)sk.getN(), (long)1127L);
        GenericSortedViewIterator itr = sk.getSortedView().iterator();
        KllMiscItemsTest.println("### SORTED VIEW");
        KllMiscItemsTest.printf("%12s %12s %12s" + Util.LS, "Value", "Weight", "NaturalRank");
        long cumWt = 0L;
        while (itr.next()) {
            String v = (String)itr.getQuantile();
            long wt = itr.getWeight();
            long natRank = itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE);
            Assert.assertEquals((long)(cumWt += wt), (long)natRank);
            KllMiscItemsTest.printf("%12s %12d %12d" + Util.LS, v, wt, natRank);
        }
        Assert.assertEquals((long)cumWt, (long)sk.getN());
    }

    @Test
    public void checkGrowLevels() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 21;
        int digits = Util.numDigits((long)21L);
        for (int i = 1; i <= 21; ++i) {
            sk.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure)[2], (int)33);
    }

    @Test
    public void checkSketchInitializeItemsHeap() {
        int k = 20;
        int n = 21;
        int digits = Util.numDigits((long)21L);
        KllMiscItemsTest.println("#### CASE: ITEM FULL HEAP");
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= 21; ++i) {
            sk.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
        }
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((String)((String)sk.getMaxItem()), (String)"21");
        Assert.assertEquals((String)((String)sk.getMinItem()), (String)" 1");
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscItemsTest.println("#### CASE: ITEM HEAP EMPTY");
        sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscItemsTest.println("#### CASE: ITEM HEAP SINGLE");
        sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        KllMiscItemsTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((String)((String)sk.getMaxItem()), (String)"1");
        Assert.assertEquals((String)((String)sk.getMinItem()), (String)"1");
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeItemsHeapifyCompactMemorySegment() {
        int k = 20;
        int n = 21;
        int digits = Util.numDigits((long)21L);
        KllMiscItemsTest.println("#### CASE: ITEM FULL HEAPIFIED FROM COMPACT");
        KllItemsSketch sk2 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
        }
        KllMiscItemsTest.println(sk2.toString(true, true));
        byte[] compBytes = sk2.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(compBytes);
        KllMiscItemsTest.println(KllPreambleUtil.toString((MemorySegment)seg, (KllSketch.SketchType)KllSketch.SketchType.KLL_ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
        KllItemsSketch sk = KllItemsSketch.heapify((MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)21L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((String)((String)sk.getMaxItem()), (String)"21");
        Assert.assertEquals((String)((String)sk.getMinItem()), (String)" 1");
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscItemsTest.println("#### CASE: ITEM EMPTY HEAPIFIED FROM COMPACT");
        sk2 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        compBytes = sk2.toByteArray();
        seg = MemorySegment.ofArray(compBytes);
        KllMiscItemsTest.println(KllPreambleUtil.toString((MemorySegment)seg, (KllSketch.SketchType)KllSketch.SketchType.KLL_ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
        sk = KllItemsSketch.heapify((MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscItemsTest.println("#### CASE: ITEM SINGLE HEAPIFIED FROM COMPACT");
        sk2 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk2.update((Object)"1");
        compBytes = sk2.toByteArray();
        seg = MemorySegment.ofArray(compBytes);
        KllMiscItemsTest.println(KllPreambleUtil.toString((MemorySegment)seg, (KllSketch.SketchType)KllSketch.SketchType.KLL_ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
        sk = KllItemsSketch.heapify((MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((int)sk.getK(), (int)20);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)20);
        Assert.assertEquals((int)((String[])sk.getTotalItemsArray()).length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((String)((String)sk.getMaxItem()), (String)"1");
        Assert.assertEquals((String)((String)sk.getMinItem()), (String)"1");
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringItemsCompact() {
        int k = 20;
        int n = 21;
        int digits = Util.numDigits((long)21L);
        KllMiscItemsTest.println("#### CASE: ITEM FULL COMPACT");
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (int i = 1; i <= 21; ++i) {
            sk.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
        }
        byte[] compBytes = sk.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(compBytes);
        String s = KllPreambleUtil.toString((MemorySegment)seg, (KllSketch.SketchType)KllSketch.SketchType.KLL_ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscItemsTest.println(s);
        KllItemsSketch sk2 = KllItemsSketch.heapify((MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        byte[] compBytes2 = sk2.toByteArray();
        seg = MemorySegment.ofArray(compBytes2);
        s = KllPreambleUtil.toString((MemorySegment)seg, (KllSketch.SketchType)KllSketch.SketchType.KLL_ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscItemsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscItemsTest.println("#### CASE: ITEM EMPTY COMPACT");
        sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        compBytes = sk.toByteArray();
        seg = MemorySegment.ofArray(compBytes);
        s = KllPreambleUtil.toString((MemorySegment)seg, (KllSketch.SketchType)KllSketch.SketchType.KLL_ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscItemsTest.println(s);
        sk2 = KllItemsSketch.heapify((MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        compBytes2 = sk2.toByteArray();
        seg = MemorySegment.ofArray(compBytes2);
        s = KllPreambleUtil.toString((MemorySegment)seg, (KllSketch.SketchType)KllSketch.SketchType.KLL_ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscItemsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscItemsTest.println("#### CASE: ITEM SINGLE COMPACT");
        sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        compBytes = sk.toByteArray();
        seg = MemorySegment.ofArray(compBytes);
        s = KllPreambleUtil.toString((MemorySegment)seg, (KllSketch.SketchType)KllSketch.SketchType.KLL_ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 1: sketch to byte[]/MemorySegment & analyze MemorySegment");
        KllMiscItemsTest.println(s);
        sk2 = KllItemsSketch.heapify((MemorySegment)seg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        compBytes2 = sk2.toByteArray();
        seg = MemorySegment.ofArray(compBytes2);
        s = KllPreambleUtil.toString((MemorySegment)seg, (KllSketch.SketchType)KllSketch.SketchType.KLL_ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe);
        KllMiscItemsTest.println("step 2: MemorySegment to heap sketch, to byte[]/MemorySegment & analyze MemorySegment. Should match above");
        KllMiscItemsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
    }

    @Test
    public void checkCreateItemsArray() {
        String item = "10";
        int weight = 108;
        Object[] itemsArr = (String[])KllItemsHelper.createItemsArray(String.class, (Object)"10", (long)108L);
        Assert.assertEquals((int)itemsArr.length, (int)4);
        Arrays.fill(itemsArr, "10");
        KllMiscItemsTest.outputItems((String[])itemsArr);
    }

    private static void outputItems(String[] itemsArr) {
        String[] hdr2 = new String[]{"Index", "Value"};
        String hdr2fmt = "%6s %15s" + Util.LS;
        String d2fmt = "%6d %15s" + Util.LS;
        KllMiscItemsTest.println("ItemsArr");
        KllMiscItemsTest.printf(hdr2fmt, hdr2);
        for (int i = 0; i < itemsArr.length; ++i) {
            KllMiscItemsTest.printf(d2fmt, i, itemsArr[i]);
        }
        KllMiscItemsTest.println("");
    }

    @Test
    public void checkCreateLevelsArray() {
        int weight = 108;
        int[] levelsArr = KllHelper.createLevelsArray((long)108L);
        Assert.assertEquals((int)levelsArr.length, (int)8);
        int[] correct = new int[]{0, 0, 0, 1, 2, 2, 3, 4};
        for (int i = 0; i < levelsArr.length; ++i) {
            Assert.assertEquals((int)levelsArr[i], (int)correct[i]);
        }
        KllMiscItemsTest.outputLevels(108, levelsArr);
    }

    private static void outputLevels(int weight, int[] levelsArr) {
        String[] hdr = new String[]{"Lvl", "StartAdr", "BitPattern", "Weight"};
        String hdrfmt = "%3s %9s %10s %s" + Util.LS;
        String dfmt = "%3d %9d %10d %d" + Util.LS;
        String dfmt_2 = "%3d %9d %s" + Util.LS;
        KllMiscItemsTest.println("Count = " + weight + " => " + Integer.toBinaryString(weight));
        KllMiscItemsTest.println("LevelsArr");
        KllMiscItemsTest.printf(hdrfmt, hdr);
        for (int i = 0; i < levelsArr.length; ++i) {
            if (i == levelsArr.length - 1) {
                KllMiscItemsTest.printf(dfmt_2, i, levelsArr[i], "ItemsArr.length");
                continue;
            }
            int j = Util.bitAt((long)weight, (int)i);
            KllMiscItemsTest.printf(dfmt, i, levelsArr[i], j, 1 << i);
        }
        KllMiscItemsTest.println("");
    }

    @Test
    public void checkGetSingleItem() {
        int k = 20;
        KllItemsSketch skHeap = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        skHeap.update((Object)"1");
        Assert.assertTrue((boolean)(skHeap instanceof KllHeapItemsSketch));
        Assert.assertEquals((String)((String)skHeap.getSingleItem()), (String)"1");
        MemorySegment srcSeg = MemorySegment.ofArray(KllHelper.toByteArray((KllSketch)skHeap, (boolean)true));
        KllItemsSketch skDirect = KllItemsSketch.wrap((MemorySegment)srcSeg, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(skDirect instanceof KllDirectCompactItemsSketch));
        Assert.assertEquals((String)((String)skDirect.getSingleItem()), (String)"1");
        MemorySegment srcSeg2 = MemorySegment.ofArray(skHeap.toByteArray());
        KllItemsSketch skCompact = KllItemsSketch.wrap((MemorySegment)srcSeg2, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(skCompact instanceof KllDirectCompactItemsSketch));
        Assert.assertEquals((String)((String)skCompact.getSingleItem()), (String)"1");
    }

    @Test
    public void checkIssue484() {
        int k = 20;
        Boolean[] items = new Boolean[]{true, false, true, false, true, false, true, false, true, false};
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance((int)20, Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        for (int i = 0; i < items.length; ++i) {
            sketch.update((Object)items[i]);
        }
        byte[] serialized = sketch.toByteArray();
        KllItemsSketch deserialized = KllItemsSketch.wrap((MemorySegment)MemorySegment.ofArray(serialized), Boolean::compareTo, (ArrayOfItemsSerDe)new ArrayOfBooleansSerDe());
        KllMiscItemsTest.checkSketchesEqual(sketch, deserialized);
    }

    private static <T> void checkSketchesEqual(KllItemsSketch<T> expected, KllItemsSketch<T> actual) {
        ItemsSketchSortedView expSV = expected.getSortedView();
        ItemsSketchSortedView actSV = actual.getSortedView();
        int N = (int)actSV.getN();
        long[] expCumWts = expSV.getCumulativeWeights();
        Object[] expItemsArr = (Boolean[])expSV.getQuantiles();
        long[] actCumWts = actSV.getCumulativeWeights();
        Object[] actItemsArr = (Boolean[])actSV.getQuantiles();
        KllMiscItemsTest.printf("%3s %8s %8s" + Util.LS, "i", "Actual", "Expected");
        for (int i = 0; i < N; ++i) {
            KllMiscItemsTest.printf("%3d %8s %8s" + Util.LS, i, ((Boolean)actItemsArr[i]).toString(), ((Boolean)expItemsArr[i]).toString());
        }
        Assert.assertEquals((long[])actCumWts, (long[])expCumWts);
        Assert.assertEquals((Object[])actItemsArr, (Object[])expItemsArr);
        Assert.assertEquals((Object)actual.getMinItem(), (Object)expected.getMinItem());
        Assert.assertEquals((Object)actual.getMaxItem(), (Object)expected.getMaxItem());
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

