/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.security.Principal;
import java.util.Enumeration;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.api.security.principal.JackrabbitPrincipal;

public final class EveryonePrincipal
implements GroupPrincipal,
JackrabbitPrincipal {
    public static final String NAME = "everyone";
    private static final EveryonePrincipal INSTANCE = new EveryonePrincipal();

    private EveryonePrincipal() {
    }

    public static EveryonePrincipal getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean addMember(Principal user) {
        return false;
    }

    public boolean removeMember(Principal user) {
        throw new UnsupportedOperationException("Cannot remove a member from the everyone group.");
    }

    @Override
    public boolean isMember(Principal member) {
        return !member.equals(this);
    }

    @Override
    public Enumeration<? extends Principal> members() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public int hashCode() {
        return NAME.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this || obj instanceof EveryonePrincipal) {
            return true;
        }
        if (obj instanceof JackrabbitPrincipal) {
            return NAME.equals(((JackrabbitPrincipal)obj).getName());
        }
        return false;
    }
}

