/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.artifact.repository.metadata.BaseObject;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.WrapperList;

@Generated
public class Metadata
extends BaseObject {
    public Metadata() {
        this(org.apache.maven.api.metadata.Metadata.newInstance());
    }

    public Metadata(org.apache.maven.api.metadata.Metadata delegate) {
        this(delegate, (BaseObject)null);
    }

    public Metadata(org.apache.maven.api.metadata.Metadata delegate, BaseObject parent) {
        super((Object)delegate, parent);
    }

    public Metadata clone() {
        return new Metadata(this.getDelegate());
    }

    public org.apache.maven.api.metadata.Metadata getDelegate() {
        return (org.apache.maven.api.metadata.Metadata)super.getDelegate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public String getModelEncoding() {
        return this.getDelegate().getModelEncoding();
    }

    public String getModelVersion() {
        return this.getDelegate().getModelVersion();
    }

    public void setModelVersion(String modelVersion) {
        if (!Objects.equals(modelVersion, this.getModelVersion())) {
            this.update(this.getDelegate().withModelVersion(modelVersion));
        }
    }

    public String getGroupId() {
        return this.getDelegate().getGroupId();
    }

    public void setGroupId(String groupId) {
        if (!Objects.equals(groupId, this.getGroupId())) {
            this.update(this.getDelegate().withGroupId(groupId));
        }
    }

    public String getArtifactId() {
        return this.getDelegate().getArtifactId();
    }

    public void setArtifactId(String artifactId) {
        if (!Objects.equals(artifactId, this.getArtifactId())) {
            this.update(this.getDelegate().withArtifactId(artifactId));
        }
    }

    public Versioning getVersioning() {
        return this.getDelegate().getVersioning() != null ? new Versioning(this.getDelegate().getVersioning(), (BaseObject)this) : null;
    }

    public void setVersioning(Versioning versioning) {
        if (!Objects.equals(versioning, this.getVersioning())) {
            if (versioning != null) {
                this.update(this.getDelegate().withVersioning(versioning.getDelegate()));
                versioning.childrenTracking = this::replace;
            } else {
                this.update(this.getDelegate().withVersioning(null));
            }
        }
    }

    public String getVersion() {
        return this.getDelegate().getVersion();
    }

    public void setVersion(String version) {
        if (!Objects.equals(version, this.getVersion())) {
            this.update(this.getDelegate().withVersion(version));
        }
    }

    @Nonnull
    public List<Plugin> getPlugins() {
        return new WrapperList<Plugin, org.apache.maven.api.metadata.Plugin>(() -> this.getDelegate().getPlugins(), l -> this.update(this.getDelegate().withPlugins((Collection)l)), d -> new Plugin((org.apache.maven.api.metadata.Plugin)d, (BaseObject)this), Plugin::getDelegate);
    }

    public void setPlugins(List<Plugin> plugins) {
        if (plugins == null) {
            plugins = Collections.emptyList();
        }
        if (!Objects.equals(plugins, this.getPlugins())) {
            this.update(this.getDelegate().withPlugins((Collection)plugins.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            plugins.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addPlugin(Plugin plugin) {
        this.update(this.getDelegate().withPlugins((Collection)Stream.concat(this.getDelegate().getPlugins().stream(), Stream.of(plugin.getDelegate())).collect(Collectors.toList())));
        plugin.childrenTracking = this::replace;
    }

    public void removePlugin(Plugin plugin) {
        this.update(this.getDelegate().withPlugins((Collection)this.getDelegate().getPlugins().stream().filter(e -> !Objects.equals(e, plugin)).collect(Collectors.toList())));
        plugin.childrenTracking = null;
    }

    @Override
    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (oldDelegate == this.getDelegate().getVersioning()) {
            this.update(this.getDelegate().withVersioning((org.apache.maven.api.metadata.Versioning)newDelegate));
            return true;
        }
        if (this.getDelegate().getPlugins().contains(oldDelegate)) {
            ArrayList list = new ArrayList(this.getDelegate().getPlugins());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.metadata.Plugin)newDelegate : d);
            this.update(this.getDelegate().withPlugins(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.api.metadata.Metadata> metadataToApiV4(List<Metadata> list) {
        return list != null ? new WrapperList<org.apache.maven.api.metadata.Metadata, Metadata>(list, Metadata::getDelegate, Metadata::new) : null;
    }

    public static List<Metadata> metadataToApiV3(List<org.apache.maven.api.metadata.Metadata> list) {
        return list != null ? new WrapperList<Metadata, org.apache.maven.api.metadata.Metadata>(list, Metadata::new, Metadata::getDelegate) : null;
    }

    private String getSnapshotVersionKey(SnapshotVersion sv) {
        return sv.getClassifier() + ":" + sv.getExtension();
    }

    public boolean merge(Metadata sourceMetadata) {
        boolean changed = false;
        for (Plugin plugin : sourceMetadata.getPlugins()) {
            boolean found = false;
            for (Plugin preExisting : this.getPlugins()) {
                if (!Objects.equals(preExisting.getPrefix(), plugin.getPrefix())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Plugin mappedPlugin = new Plugin();
            mappedPlugin.setArtifactId(plugin.getArtifactId());
            mappedPlugin.setPrefix(plugin.getPrefix());
            mappedPlugin.setName(plugin.getName());
            this.addPlugin(mappedPlugin);
            changed = true;
        }
        Versioning versioning = sourceMetadata.getVersioning();
        if (versioning != null) {
            Versioning v = this.getVersioning();
            if (v == null) {
                v = new Versioning();
                this.setVersioning(v);
                changed = true;
            }
            for (String version : versioning.getVersions()) {
                if (v.getVersions().contains(version)) continue;
                changed = true;
                v.getVersions().add(version);
            }
            if ("null".equals(versioning.getLastUpdated())) {
                versioning.setLastUpdated(null);
            }
            if ("null".equals(v.getLastUpdated())) {
                v.setLastUpdated(null);
            }
            if (versioning.getLastUpdated() == null || versioning.getLastUpdated().length() == 0) {
                versioning.setLastUpdated(v.getLastUpdated());
            }
            if (v.getLastUpdated() == null || v.getLastUpdated().length() == 0 || versioning.getLastUpdated().compareTo(v.getLastUpdated()) >= 0) {
                changed = true;
                v.setLastUpdated(versioning.getLastUpdated());
                if (versioning.getRelease() != null) {
                    changed = true;
                    v.setRelease(versioning.getRelease());
                }
                if (versioning.getLatest() != null) {
                    changed = true;
                    v.setLatest(versioning.getLatest());
                }
                Snapshot s = v.getSnapshot();
                Snapshot snapshot = versioning.getSnapshot();
                if (snapshot != null) {
                    boolean updateSnapshotVersions = false;
                    if (s == null) {
                        s = new Snapshot();
                        v.setSnapshot(s);
                        changed = true;
                        updateSnapshotVersions = true;
                    }
                    if (s.getTimestamp() == null ? snapshot.getTimestamp() != null : !s.getTimestamp().equals(snapshot.getTimestamp())) {
                        s.setTimestamp(snapshot.getTimestamp());
                        changed = true;
                        updateSnapshotVersions = true;
                    }
                    if (s.getBuildNumber() != snapshot.getBuildNumber()) {
                        s.setBuildNumber(snapshot.getBuildNumber());
                        changed = true;
                    }
                    if (s.isLocalCopy() != snapshot.isLocalCopy()) {
                        s.setLocalCopy(snapshot.isLocalCopy());
                        changed = true;
                    }
                    if (updateSnapshotVersions) {
                        LinkedHashMap<String, SnapshotVersion> versions = new LinkedHashMap<String, SnapshotVersion>();
                        if (!v.getSnapshotVersions().isEmpty()) {
                            String key;
                            for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
                                key = this.getSnapshotVersionKey(sv);
                                versions.put(key, sv);
                            }
                            if (!versions.isEmpty()) {
                                for (SnapshotVersion sv : v.getSnapshotVersions()) {
                                    key = this.getSnapshotVersionKey(sv);
                                    if (versions.containsKey(key)) continue;
                                    versions.put(key, sv);
                                }
                            }
                            v.setSnapshotVersions(new ArrayList<SnapshotVersion>(versions.values()));
                        }
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }
}

