/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sshd.common.BuiltinFactory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;

public interface SignatureFactory
extends BuiltinFactory<Signature> {
    public static final List<String> ECC_SIGNATURE_TYPE_PREFERENCES = Collections.unmodifiableList(Arrays.asList(KeyPairProvider.ECDSA_SHA2_NISTP521, KeyPairProvider.ECDSA_SHA2_NISTP384, KeyPairProvider.ECDSA_SHA2_NISTP256));
    public static final List<String> RSA_SIGNATURE_TYPE_PREFERENCES = Collections.unmodifiableList(Arrays.asList("rsa-sha2-512", "rsa-sha2-256", "ssh-rsa"));

    public static List<String> resolveSignatureFactoriesProposal(Iterable<String> provided, Collection<? extends NamedFactory<Signature>> factories) {
        return SignatureFactory.resolveSignatureFactoryNamesProposal(provided, NamedResource.getNameList(factories));
    }

    public static List<String> resolveSignatureFactoryNamesProposal(Iterable<String> provided, Collection<String> available) {
        if (provided == null || GenericUtils.isEmpty(available)) {
            return Collections.emptyList();
        }
        HashSet<String> providedKeys = new HashSet<String>();
        for (String providedType : provided) {
            List<String> equivTypes = KeyUtils.getAllEquivalentKeyTypes(providedType);
            providedKeys.addAll(equivTypes);
        }
        if (GenericUtils.isEmpty(providedKeys)) {
            return Collections.emptyList();
        }
        ArrayList<String> supported = new ArrayList<String>(available);
        for (int index = 0; index < supported.size(); ++index) {
            String kt = (String)supported.get(index);
            if (providedKeys.contains(kt)) continue;
            supported.remove(index);
            --index;
        }
        return supported;
    }

    public static int resolvePreferredSignaturePosition(List<? extends NamedFactory<Signature>> factories, NamedFactory<Signature> factory) {
        if (GenericUtils.isEmpty(factories)) {
            return -1;
        }
        String name = factory.getName();
        if ("ssh-rsa".equalsIgnoreCase(name)) {
            return -1;
        }
        int pos = RSA_SIGNATURE_TYPE_PREFERENCES.indexOf(name);
        if (pos >= 0) {
            TreeMap<String, Integer> posMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            int count = factories.size();
            for (int index = 0; index < count; ++index) {
                NamedFactory<Signature> f = factories.get(index);
                String keyType = f.getName();
                String canonicalName = KeyUtils.getCanonicalKeyType(keyType);
                if (!"ssh-rsa".equalsIgnoreCase(canonicalName)) continue;
                posMap.put(keyType, index);
            }
            return SignatureFactory.resolvePreferredSignaturePosition(RSA_SIGNATURE_TYPE_PREFERENCES, pos, posMap);
        }
        pos = ECC_SIGNATURE_TYPE_PREFERENCES.indexOf(name);
        if (pos >= 0) {
            TreeMap<String, Integer> posMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            int count = factories.size();
            for (int index = 0; index < count; ++index) {
                NamedFactory<Signature> f = factories.get(index);
                String keyType = f.getName();
                if (!ECC_SIGNATURE_TYPE_PREFERENCES.contains(keyType)) continue;
                posMap.put(keyType, index);
            }
            return SignatureFactory.resolvePreferredSignaturePosition(ECC_SIGNATURE_TYPE_PREFERENCES, pos, posMap);
        }
        return -1;
    }

    public static int resolvePreferredSignaturePosition(List<String> preferredOrder, int prefValue, Map<String, Integer> posMap) {
        if (GenericUtils.isEmpty(preferredOrder) || prefValue < 0 || MapEntryUtils.isEmpty(posMap)) {
            return -1;
        }
        int posValue = -1;
        for (Map.Entry<String, Integer> pe : posMap.entrySet()) {
            int resIndex;
            String name = pe.getKey();
            int order = preferredOrder.indexOf(name);
            if (order < 0) continue;
            Integer curIndex = pe.getValue();
            if (order < prefValue) {
                resIndex = curIndex + 1;
            } else {
                if (order <= prefValue) continue;
                resIndex = curIndex;
            }
            if (posValue >= 0 && resIndex >= posValue) continue;
            posValue = resIndex;
        }
        return posValue;
    }

    public static NamedFactory<? extends Signature> resolveSignatureFactory(String keyType, Collection<? extends NamedFactory<? extends Signature>> factories) {
        if (GenericUtils.isEmpty(keyType) || GenericUtils.isEmpty(factories)) {
            return null;
        }
        List<String> aliases = KeyUtils.getAllEquivalentKeyTypes(keyType);
        if (GenericUtils.isEmpty(aliases)) {
            return NamedResource.findByName(keyType, String.CASE_INSENSITIVE_ORDER, factories);
        }
        return NamedResource.findFirstMatchByName(aliases, String.CASE_INSENSITIVE_ORDER, factories);
    }

    public static NamedFactory<Signature> resolveSignatureFactoryByPublicKey(PublicKey pubKey, String algo) throws InvalidKeySpecException {
        if (pubKey == null) {
            return null;
        }
        BuiltinSignatures factory = null;
        if (pubKey instanceof DSAPublicKey) {
            factory = BuiltinSignatures.dsa;
        } else if (pubKey instanceof ECPublicKey) {
            ECPublicKey ecKey = (ECPublicKey)pubKey;
            factory = BuiltinSignatures.getFactoryByCurveSize(ecKey.getParams());
        } else if (pubKey instanceof RSAPublicKey) {
            if (GenericUtils.isEmpty(algo)) {
                factory = BuiltinSignatures.rsa;
            } else if (algo.contains("rsa")) {
                factory = BuiltinSignatures.fromFactoryName(algo);
            }
        } else if ("EdDSA".equalsIgnoreCase(pubKey.getAlgorithm()) || "Ed25519".equalsIgnoreCase(pubKey.getAlgorithm())) {
            factory = BuiltinSignatures.ed25519;
        }
        if (GenericUtils.isEmpty(algo) || factory == null) {
            return factory;
        }
        String name = factory.getName();
        if (!algo.equalsIgnoreCase(name)) {
            throw new InvalidKeySpecException("Mismatched factory name (" + name + ") for algorithm=" + algo + " when using key type" + KeyUtils.getKeyType(pubKey));
        }
        return factory;
    }
}

