/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sts.model.StsRequest;
import software.amazon.awssdk.services.sts.model.Tag;
import software.amazon.awssdk.services.sts.model._tagListTypeCopier;
import software.amazon.awssdk.services.sts.model._webIdentityTokenAudienceListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWebIdentityTokenRequest
extends StsRequest
implements ToCopyableBuilder<Builder, GetWebIdentityTokenRequest> {
    private static final SdkField<List<String>> AUDIENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Audience").getter(GetWebIdentityTokenRequest.getter(GetWebIdentityTokenRequest::audience)).setter(GetWebIdentityTokenRequest.setter(Builder::audience)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audience").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationSeconds").getter(GetWebIdentityTokenRequest.getter(GetWebIdentityTokenRequest::durationSeconds)).setter(GetWebIdentityTokenRequest.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()}).build();
    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAlgorithm").getter(GetWebIdentityTokenRequest.getter(GetWebIdentityTokenRequest::signingAlgorithm)).setter(GetWebIdentityTokenRequest.setter(Builder::signingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(GetWebIdentityTokenRequest.getter(GetWebIdentityTokenRequest::tags)).setter(GetWebIdentityTokenRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCE_FIELD, DURATION_SECONDS_FIELD, SIGNING_ALGORITHM_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWebIdentityTokenRequest.memberNameToFieldInitializer();
    private final List<String> audience;
    private final Integer durationSeconds;
    private final String signingAlgorithm;
    private final List<Tag> tags;

    private GetWebIdentityTokenRequest(BuilderImpl builder) {
        super(builder);
        this.audience = builder.audience;
        this.durationSeconds = builder.durationSeconds;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.tags = builder.tags;
    }

    public final boolean hasAudience() {
        return this.audience != null && !(this.audience instanceof SdkAutoConstructList);
    }

    public final List<String> audience() {
        return this.audience;
    }

    public final Integer durationSeconds() {
        return this.durationSeconds;
    }

    public final String signingAlgorithm() {
        return this.signingAlgorithm;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudience() ? this.audience() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWebIdentityTokenRequest)) {
            return false;
        }
        GetWebIdentityTokenRequest other = (GetWebIdentityTokenRequest)((Object)obj);
        return this.hasAudience() == other.hasAudience() && Objects.equals(this.audience(), other.audience()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.signingAlgorithm(), other.signingAlgorithm()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetWebIdentityTokenRequest").add("Audience", this.hasAudience() ? this.audience() : null).add("DurationSeconds", (Object)this.durationSeconds()).add("SigningAlgorithm", (Object)this.signingAlgorithm()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Audience": {
                return Optional.ofNullable(clazz.cast(this.audience()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithm()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Audience", AUDIENCE_FIELD);
        map.put("DurationSeconds", DURATION_SECONDS_FIELD);
        map.put("SigningAlgorithm", SIGNING_ALGORITHM_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWebIdentityTokenRequest, T> g) {
        return obj -> g.apply((GetWebIdentityTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StsRequest.BuilderImpl
    implements Builder {
        private List<String> audience = DefaultSdkAutoConstructList.getInstance();
        private Integer durationSeconds;
        private String signingAlgorithm;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetWebIdentityTokenRequest model) {
            super(model);
            this.audience(model.audience);
            this.durationSeconds(model.durationSeconds);
            this.signingAlgorithm(model.signingAlgorithm);
            this.tags(model.tags);
        }

        public final Collection<String> getAudience() {
            if (this.audience instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audience;
        }

        public final void setAudience(Collection<String> audience) {
            this.audience = _webIdentityTokenAudienceListTypeCopier.copy(audience);
        }

        @Override
        public final Builder audience(Collection<String> audience) {
            this.audience = _webIdentityTokenAudienceListTypeCopier.copy(audience);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audience(String ... audience) {
            this.audience(Arrays.asList(audience));
            return this;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWebIdentityTokenRequest build() {
            return new GetWebIdentityTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWebIdentityTokenRequest> {
        public Builder audience(Collection<String> var1);

        public Builder audience(String ... var1);

        public Builder durationSeconds(Integer var1);

        public Builder signingAlgorithm(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

