/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.security.CertificateDetails;
import org.apache.qpid.server.security.ManagedPeerCertificateTrustStoreImpl;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;

final class ManagedPeerCertificateTrustStoreImplWithAccessChecking
extends ManagedPeerCertificateTrustStoreImpl {
    private static final FixedKeyMapCreator ADD_CERTIFICATE_MAP_CREATOR = new FixedKeyMapCreator("certificate");
    private static final FixedKeyMapCreator REMOVE_CERTIFICATES_MAP_CREATOR = new FixedKeyMapCreator("certificates");

    ManagedPeerCertificateTrustStoreImplWithAccessChecking(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public Map<String, Object> getStatistics(List<String> statistics) {
        return super.getStatistics(statistics);
    }

    @Override
    public String setContextVariable(final String name, final String value) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<String> execute() {
                return CompletableFuture.completedFuture(ManagedPeerCertificateTrustStoreImplWithAccessChecking.super.setContextVariable(name, value));
            }

            @Override
            public String getObject() {
                return ManagedPeerCertificateTrustStoreImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "setContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name + ",value=" + value;
                }
                return this._args;
            }
        }));
    }

    @Override
    public String removeContextVariable(final String name) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<String> execute() {
                return CompletableFuture.completedFuture(ManagedPeerCertificateTrustStoreImplWithAccessChecking.super.removeContextVariable(name));
            }

            @Override
            public String getObject() {
                return ManagedPeerCertificateTrustStoreImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "removeContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void addCertificate(final Certificate certificate) {
        this.authorise(Operation.INVOKE_METHOD("addCertificate"), ADD_CERTIFICATE_MAP_CREATOR.createMap(certificate));
        this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Void> execute() {
                ManagedPeerCertificateTrustStoreImplWithAccessChecking.super.addCertificate(certificate);
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public String getObject() {
                return ManagedPeerCertificateTrustStoreImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "addCertificate";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "certificate=" + String.valueOf(certificate);
                }
                return this._args;
            }
        }));
    }

    @Override
    public void removeCertificates(final List<CertificateDetails> certificates) {
        this.authorise(Operation.INVOKE_METHOD("removeCertificates"), REMOVE_CERTIFICATES_MAP_CREATOR.createMap(certificates));
        this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Void> execute() {
                ManagedPeerCertificateTrustStoreImplWithAccessChecking.super.removeCertificates(certificates);
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public String getObject() {
                return ManagedPeerCertificateTrustStoreImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "removeCertificates";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "certificates=" + String.valueOf(certificates);
                }
                return this._args;
            }
        }));
    }
}

