/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.crammd5;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.sasl.AbstractSaslServerNegotiator;
import org.apache.qpid.server.security.auth.sasl.PasswordSource;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCramMd5Negotiator
extends AbstractSaslServerNegotiator
implements SaslNegotiator {
    protected static final PasswordTransformer PLAIN_PASSWORD_TRANSFORMER = passwordData -> passwordData;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCramMd5Negotiator.class);
    private final SaslServer _saslServer;
    private final SaslException _exception;
    private final PasswordCredentialManagingAuthenticationProvider<?> _authenticationProvider;
    private volatile String _username;

    AbstractCramMd5Negotiator(PasswordCredentialManagingAuthenticationProvider<?> authenticationProvider, String localFQDN, PasswordSource passwordSource, PasswordTransformer passwordTransformer) {
        this._authenticationProvider = authenticationProvider;
        SaslServer saslServer = null;
        SaslException exception = null;
        try {
            saslServer = Sasl.createSaslServer("CRAM-MD5", "AMQP", localFQDN, null, new ServerCallbackHandler(passwordSource, passwordTransformer));
        }
        catch (SaslException e) {
            exception = e;
            LOGGER.warn("Creation of SASL server for mechanism '{}' failed.", (Object)"CRAM-MD5", (Object)e);
        }
        this._saslServer = saslServer;
        this._exception = exception;
    }

    @Override
    protected Exception getSaslServerCreationException() {
        return this._exception;
    }

    @Override
    protected SaslServer getSaslServer() {
        return this._saslServer;
    }

    @Override
    protected AuthenticationProvider<?> getAuthenticationProvider() {
        return this._authenticationProvider;
    }

    @Override
    public String getAttemptedAuthenticationId() {
        return this._username;
    }

    private class ServerCallbackHandler
    implements CallbackHandler {
        private final PasswordSource _passwordSource;
        private final PasswordTransformer _passwordTransformer;

        private ServerCallbackHandler(PasswordSource passwordSource, PasswordTransformer passwordTransformer) {
            this._passwordTransformer = passwordTransformer;
            this._passwordSource = passwordSource;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Callback callback;
            ArrayList<Callback> callbackList = new ArrayList<Callback>(Arrays.asList(callbacks));
            Iterator iter = callbackList.iterator();
            while (iter.hasNext()) {
                callback = (Callback)iter.next();
                if (!(callback instanceof NameCallback)) continue;
                AbstractCramMd5Negotiator.this._username = ((NameCallback)callback).getDefaultName();
                iter.remove();
                break;
            }
            if (AbstractCramMd5Negotiator.this._username != null) {
                iter = callbackList.iterator();
                while (iter.hasNext()) {
                    callback = (Callback)iter.next();
                    if (!(callback instanceof PasswordCallback)) continue;
                    iter.remove();
                    char[] passwordData = this._passwordSource.getPassword(AbstractCramMd5Negotiator.this._username);
                    if (passwordData != null) {
                        ((PasswordCallback)callback).setPassword(this._passwordTransformer.transform(passwordData));
                        break;
                    }
                    ((PasswordCallback)callback).setPassword(null);
                    break;
                }
            }
            for (Callback callback2 : callbackList) {
                if (callback2 instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback2).setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callback2);
            }
        }
    }

    static interface PasswordTransformer {
        public char[] transform(char[] var1);
    }
}

