/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;

public class HandleLocker
extends BasicLocker {
    private final long shareWithTxnId;
    private final Locker shareWithNonTxnlLocker;

    protected HandleLocker(EnvironmentImpl env, Locker buddy) {
        super(env);
        this.shareWithTxnId = buddy.isTransactional() ? buddy.getId() : -1L;
        this.shareWithNonTxnlLocker = buddy.isTransactional() ? null : buddy;
    }

    public static HandleLocker createHandleLocker(EnvironmentImpl env, Locker buddy) throws DatabaseException {
        return new HandleLocker(env, buddy);
    }

    @Override
    public boolean sharesLocksWith(Locker other) {
        if (super.sharesLocksWith(other)) {
            return true;
        }
        if (this.shareWithTxnId != -1L && this.shareWithTxnId == other.getId()) {
            return true;
        }
        return this.shareWithNonTxnlLocker != null && this.shareWithNonTxnlLocker == other;
    }

    @Override
    public boolean allowReleaseLockAfterLsnChange() {
        return true;
    }
}

