/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport.mimecontentconverter;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentToObjectConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_10.transport.BBDecoder;

@PluggableService
public class AmqpMapToMapConverter
implements MimeContentToObjectConverter<Map> {
    public String getType() {
        return this.getMimeType();
    }

    public Class<Map> getObjectClass() {
        return Map.class;
    }

    public String getMimeType() {
        return "amqp/map";
    }

    public Map toObject(byte[] data) {
        if (data == null || data.length == 0) {
            return Collections.emptyMap();
        }
        BBDecoder decoder = new BBDecoder();
        decoder.init(ByteBuffer.wrap(data));
        return decoder.readMap();
    }
}

