/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.log.logback.internal.LogbackResetListener;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.LoggerFactory;

public class TurboFilterTracker
extends ServiceTracker<TurboFilter, TurboFilter>
implements LogbackResetListener {
    private final Map<ServiceReference<TurboFilter>, TurboFilter> filters = new ConcurrentHashMap<ServiceReference<TurboFilter>, TurboFilter>();

    public TurboFilterTracker(@NotNull BundleContext context) {
        super(context, TurboFilter.class.getName(), null);
    }

    @NotNull
    public TurboFilter addingService(@NotNull ServiceReference<TurboFilter> reference) {
        TurboFilter tf = (TurboFilter)super.addingService(reference);
        this.attachFilter(tf);
        this.filters.put(reference, tf);
        return tf;
    }

    public void removedService(@NotNull ServiceReference<TurboFilter> reference, @NotNull TurboFilter service) {
        this.filters.remove(reference);
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.getTurboFilterList().remove((Object)service);
        service.stop();
        super.removedService(reference, (Object)service);
    }

    public synchronized void close() {
        super.close();
        this.filters.clear();
    }

    @NotNull
    public Map<ServiceReference<TurboFilter>, TurboFilter> getFilters() {
        return Collections.unmodifiableMap(this.filters);
    }

    @Override
    public void onResetStart(@NotNull LoggerContext context) {
        for (TurboFilter tf : this.filters.values()) {
            this.attachFilter(tf);
        }
    }

    private void attachFilter(@NotNull TurboFilter tf) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        if (!loggerContext.getTurboFilterList().contains((Object)tf)) {
            tf.setContext((Context)loggerContext);
            tf.start();
            loggerContext.addTurboFilter(tf);
        }
    }
}

