/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.servlet;

import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpSession;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.apache.sling.servlethelpers.MockHttpSession;
import org.apache.sling.servlethelpers.MockRequestPathInfo;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.osgi.framework.BundleContext;

@RunWith(value=MockitoJUnitRunner.class)
public class MockSlingHttpServletRequestTest {
    @Mock
    private ResourceResolver resourceResolver;
    @Mock
    private Resource resource;
    private BundleContext bundleContext = MockOsgi.newBundleContext();
    private MockSlingHttpServletRequest request;

    @Before
    public void setUp() throws Exception {
        this.request = new MockSlingHttpServletRequest(this.resourceResolver, this.bundleContext);
    }

    @After
    public void tearDown() {
        MockOsgi.shutdown((BundleContext)this.bundleContext);
    }

    @Test
    public void testResourceResolver() {
        Assert.assertSame((Object)this.resourceResolver, (Object)this.request.getResourceResolver());
    }

    @Test
    public void testDefaultResourceResolver() {
        Assert.assertNotNull((Object)new MockSlingHttpServletRequest(this.bundleContext).getResourceResolver());
    }

    @Test
    public void testSession() {
        HttpSession session = this.request.getSession();
        Assert.assertNotNull((Object)session);
        Assert.assertTrue((boolean)(session instanceof MockHttpSession));
    }

    @Test
    public void testRequestPathInfo() {
        Assert.assertNotNull((Object)this.request.getRequestPathInfo());
        Assert.assertTrue((boolean)(this.request.getRequestPathInfo() instanceof MockRequestPathInfo));
    }

    @Test
    public void testDefaultResourceBundle() {
        ResourceBundle bundle = this.request.getResourceBundle(Locale.US);
        Assert.assertNotNull((Object)bundle);
        Assert.assertFalse((boolean)bundle.getKeys().hasMoreElements());
    }

    @Test
    public void testResourceBundleFromProvider() {
        ResourceBundleProvider provider = (ResourceBundleProvider)Mockito.mock(ResourceBundleProvider.class);
        this.bundleContext.registerService(ResourceBundleProvider.class.getName(), (Object)provider, null);
        Mockito.when((Object)provider.getResourceBundle("base1", Locale.US)).thenReturn((Object)new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                return new Object[][]{{"key1", "value1"}};
            }
        });
        ResourceBundle bundle = this.request.getResourceBundle("base1", Locale.US);
        Assert.assertNotNull((Object)bundle);
        Assert.assertEquals((Object)"value1", (Object)bundle.getString("key1"));
        ResourceBundle bundle2 = this.request.getResourceBundle("base2", Locale.US);
        Assert.assertNotNull((Object)bundle2);
        Assert.assertFalse((boolean)bundle2.getKeys().hasMoreElements());
    }

    @Test
    public void testGetSuffixResource() {
        Assert.assertNull((Object)this.request.getRequestPathInfo().getSuffixResource());
        ((MockRequestPathInfo)this.request.getRequestPathInfo()).setSuffix("/suffix");
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)this.resourceResolver.getResource("/suffix")).thenReturn((Object)resource);
        Assert.assertSame((Object)resource, (Object)this.request.getRequestPathInfo().getSuffixResource());
    }
}

