/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.spring;

import jakarta.servlet.ServletContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.inject.Container;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.spring.ClassReloadingXMLWebApplicationContext;
import org.apache.struts2.spring.SpringObjectFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class StrutsSpringObjectFactory
extends SpringObjectFactory {
    private static final Logger LOG = LogManager.getLogger(StrutsSpringObjectFactory.class);

    public StrutsSpringObjectFactory() {
    }

    @Inject
    public StrutsSpringObjectFactory(@Inject(value="struts.objectFactory.spring.autoWire", required=false) String autoWire, @Inject(value="struts.objectFactory.spring.autoWire.alwaysRespect", required=false) String alwaysAutoWire, @Inject(value="struts.objectFactory.spring.useClassCache", required=false) String useClassCacheStr, @Inject(value="struts.objectFactory.spring.enableAopSupport", required=false) String enableAopSupport, @Inject ServletContext servletContext, @Inject(value="struts.devMode") String devMode, @Inject Container container) {
        boolean useClassCache = BooleanUtils.toBoolean((String)useClassCacheStr);
        LOG.info("Initializing Struts-Spring integration...");
        Object rootWebApplicationContext = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (rootWebApplicationContext instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)rootWebApplicationContext;
            LOG.fatal(runtimeException.getMessage());
            return;
        }
        ApplicationContext appContext = (ApplicationContext)rootWebApplicationContext;
        if (appContext == null) {
            String message = "********** FATAL ERROR STARTING UP STRUTS-SPRING INTEGRATION **********\nLooks like the Spring listener was not configured for your web app! \nNothing will work until WebApplicationContextUtils returns a valid ApplicationContext.\nYou might need to add the following to web.xml: \n    <listener>\n        <listener-class>org.springframework.web.context.ContextLoaderListener</listener-class>\n    </listener>";
            LOG.fatal(message);
            return;
        }
        String watchList = (String)container.getInstance(String.class, "struts.objectFactory.spring.class.reloading.watchList");
        String acceptClasses = (String)container.getInstance(String.class, "struts.objectFactory.spring.class.reloading.acceptClasses");
        String reloadConfig = (String)container.getInstance(String.class, "struts.objectFactory.spring.class.reloading.reloadConfig");
        if ("true".equals(devMode) && StringUtils.isNotBlank((CharSequence)watchList) && appContext instanceof ClassReloadingXMLWebApplicationContext) {
            useClassCache = false;
            try (ClassReloadingXMLWebApplicationContext reloadingContext = (ClassReloadingXMLWebApplicationContext)appContext;){
                reloadingContext.setupReloading(watchList.split(","), acceptClasses, servletContext, "true".equals(reloadConfig));
                LOG.info("Class reloading is enabled. Make sure this is not used on a production environment!\n{}", (Object)watchList);
                this.setClassLoader((ClassLoader)reloadingContext.getReloadingClassLoader());
                reloadingContext.refresh();
            }
        }
        this.setApplicationContext(appContext);
        int type = 1;
        if ("name".equals(autoWire)) {
            type = 1;
        } else if ("type".equals(autoWire)) {
            type = 2;
        } else if ("auto".equals(autoWire)) {
            type = 4;
        } else if ("constructor".equals(autoWire)) {
            type = 3;
        } else if ("no".equals(autoWire)) {
            type = 0;
        }
        this.setAutowireStrategy(type);
        this.setUseClassCache(useClassCache);
        this.setAlwaysRespectAutowireStrategy(BooleanUtils.toBoolean((String)alwaysAutoWire));
        this.setEnableAopSupport(enableAopSupport);
        LOG.info("... initialized Struts-Spring integration successfully");
    }
}

