/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.tinkerpop.gremlin.driver.UserAgent;
import org.apache.tinkerpop.gremlin.driver.exception.ResponseException;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseStatusCode;

@ChannelHandler.Sharable
public final class HttpGremlinRequestEncoder
extends MessageToMessageEncoder<RequestMessage> {
    private final MessageSerializer<?> serializer;
    private final boolean userAgentEnabled;
    private final UnaryOperator<FullHttpRequest> interceptor;

    @Deprecated
    public HttpGremlinRequestEncoder(MessageSerializer<?> serializer, UnaryOperator<FullHttpRequest> interceptor) {
        this.serializer = serializer;
        this.interceptor = interceptor;
        this.userAgentEnabled = true;
    }

    public HttpGremlinRequestEncoder(MessageSerializer<?> serializer, UnaryOperator<FullHttpRequest> interceptor, boolean userAgentEnabled) {
        this.serializer = serializer;
        this.interceptor = interceptor;
        this.userAgentEnabled = userAgentEnabled;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, RequestMessage requestMessage, List<Object> objects) throws Exception {
        String mimeType = this.serializer.mimeTypesSupported()[0];
        if (requestMessage.getArg("gremlin") instanceof Bytecode && !mimeType.equals("application/vnd.gremlin-v3.0+json") && !mimeType.equals("application/vnd.graphbinary-v1.0")) {
            throw new ResponseException(ResponseStatusCode.REQUEST_ERROR_SERIALIZATION, String.format("An error occurred during serialization of this request [%s] - it could not be sent to the server - Reason: only GraphSON3 and GraphBinary recommended for serialization of Bytecode requests, but used %s", requestMessage, this.serializer.getClass().getName()));
        }
        try {
            ByteBuf buffer = this.serializer.serializeRequestAsBinary(requestMessage, channelHandlerContext.alloc());
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/", buffer);
            request.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mimeType);
            request.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)buffer.readableBytes());
            request.headers().add((CharSequence)HttpHeaderNames.ACCEPT, (Object)mimeType);
            if (this.userAgentEnabled) {
                request.headers().add((CharSequence)HttpHeaderNames.USER_AGENT, (Object)UserAgent.USER_AGENT);
            }
            objects.add(this.interceptor.apply((FullHttpRequest)request));
        }
        catch (Exception ex) {
            throw new ResponseException(ResponseStatusCode.REQUEST_ERROR_SERIALIZATION, String.format("An error occurred during serialization of this request [%s] - it could not be sent to the server - Reason: %s", requestMessage, ex));
        }
    }
}

