/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.Digits;
import java.math.BigDecimal;

public class DigitsValidatorForString
implements ConstraintValidator<Digits, String> {
    private int integral;
    private int fractional;

    public int getIntegral() {
        return this.integral;
    }

    public void setIntegral(int integral) {
        this.integral = integral;
    }

    public int getFractional() {
        return this.fractional;
    }

    public void setFractional(int fractional) {
        this.fractional = fractional;
    }

    public void initialize(Digits annotation) {
        this.integral = annotation.integer();
        this.fractional = annotation.fraction();
        if (this.integral < 0) {
            throw new IllegalArgumentException("The length of the integer part cannot be negative.");
        }
        if (this.fractional < 0) {
            throw new IllegalArgumentException("The length of the fraction part cannot be negative.");
        }
    }

    public boolean isValid(String str, ConstraintValidatorContext context) {
        if (str == null) {
            return true;
        }
        BigDecimal bigDecimal = this.getBigDecimalValue(str);
        if (bigDecimal == null) {
            return false;
        }
        int intLength = bigDecimal.precision() - bigDecimal.scale();
        if (this.integral >= intLength) {
            int factionLength = bigDecimal.scale() < 0 ? 0 : bigDecimal.scale();
            return this.fractional >= factionLength;
        }
        return false;
    }

    private BigDecimal getBigDecimalValue(String str) {
        try {
            return new BigDecimal(str);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

