/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.uima.ruta.caseditor.view.tree;

import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;

public class TypeTreeNode extends AbstractTreeNode {

  private Type type;

  public TypeTreeNode(CAS cas, Type type) {
    this(cas, null, type);
  }

  public TypeTreeNode(CAS cas, ITreeNode parent, Type type) {
    super(cas, parent);
    this.type = type;
  }

  @Override
  public String getName() {
    return type.getName();
  }

  @Override
  public Type getType() {
    return type;
  }

  @Override
  public boolean equals(Object o) {
    if (o == null)
      return false;
    if (o instanceof TypeTreeNode) {
      return type.equals(((TypeTreeNode) o).getType());
    }
    return false;
  }

  @Override
  public int hashCode() {
    return type.hashCode();
  }

  @Override
  public Object getAdapter(@SuppressWarnings("rawtypes") Class adapter) {

    if (TypeTreeNode.class.equals(adapter)) {
      return this;
    } else if (Type.class.equals(adapter)) {
      return type;

    }

    return null;
  }

}
