/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.exceptions;

import aQute.bnd.exceptions.Exceptions;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface FunctionWithException<T, R> {
    public R apply(T var1) throws Exception;

    default public Function<T, R> orElseThrow() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        };
    }

    default public Function<T, R> orElse(R orElse) {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                return orElse;
            }
        };
    }

    default public Function<T, R> orElseGet(Supplier<? extends R> orElseGet) {
        Objects.requireNonNull(orElseGet);
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                return orElseGet.get();
            }
        };
    }

    public static <T, R> Function<T, R> asFunction(FunctionWithException<T, R> unchecked) {
        return unchecked.orElseThrow();
    }

    public static <T, R> Function<T, R> asFunctionOrElse(FunctionWithException<T, R> unchecked, R orElse) {
        return unchecked.orElse(orElse);
    }

    public static <T, R> Function<T, R> asFunctionOrElseGet(FunctionWithException<T, R> unchecked, Supplier<? extends R> orElseGet) {
        return unchecked.orElseGet(orElseGet);
    }
}

