/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.groovy.commands;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="groovy", name="exec", description="Executes Groovy code")
@Service
public class ExecGroovyCodeAction
implements Action {
    @Argument(index=0, name="script", description="Groovy code", required=true)
    private String groovyCode;
    @Argument(index=1, name="args", description="Arguments in the format of key=value", multiValued=true)
    private List<String> args;

    public Object execute() throws Exception {
        Binding binding = new Binding();
        if (this.args != null) {
            for (String arg : this.args) {
                int splitAt = arg.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid argument " + arg);
                }
                String key = arg.substring(0, splitAt);
                String value = arg.substring(splitAt + 1);
                binding.setVariable(key, (Object)value);
            }
        }
        GroovyShell sh = new GroovyShell(binding);
        System.out.println(sh.evaluate(this.groovyCode));
        return null;
    }
}

