/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.util;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import javax.security.auth.Subject;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.shell.commands.CommandException;
import org.apache.karaf.shell.commands.ansi.SimpleAnsi;
import org.apache.karaf.shell.console.CloseShellException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ShellUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellUtil.class);

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + bundle.getBundleId() : name + " (" + bundle.getBundleId() + ")";
        }
        return "[STALE BUNDLE]";
    }

    public static String getUnderlineString(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String getValueString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(ShellUtil.getValueString(array[i]));
            }
            sb.append("]");
            return sb.toString();
        }
        return obj.toString();
    }

    public static boolean isASystemBundle(BundleContext bundleContext, Bundle bundle) {
        int level = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
        int sbsl = 49;
        String sbslProp = bundleContext.getProperty("karaf.systemBundlesStartLevel");
        if (sbslProp != null) {
            try {
                sbsl = Integer.parseInt(sbslProp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return level <= sbsl;
    }

    public static boolean getBoolean(CommandSession session, String name) {
        Object s = session.get(name);
        if (s == null) {
            s = System.getProperty(name);
        }
        if (s == null) {
            return false;
        }
        if (s instanceof Boolean) {
            return (Boolean)s;
        }
        return Boolean.parseBoolean(s.toString());
    }

    public static void logException(CommandSession session, Throwable t) {
        try {
            boolean isCommandNotFound = "org.apache.felix.gogo.runtime.CommandNotFoundException".equals(t.getClass().getName());
            if (isCommandNotFound) {
                LOGGER.debug("Unknown command entered", t);
            } else if (t instanceof CommandException) {
                LOGGER.debug("Command exception (Undefined option, ...)", t);
            } else if (!(t instanceof CloseShellException)) {
                LOGGER.error("Exception caught while executing command", t);
            }
            session.put("karaf.lastException", t);
            if (t instanceof CommandException) {
                session.getConsole().println(((CommandException)t).getNiceHelp());
            } else if (isCommandNotFound) {
                String str = SimpleAnsi.COLOR_RED + "Command not found: " + SimpleAnsi.INTENSITY_BOLD + String.valueOf(t.getClass().getMethod("getCommand", new Class[0]).invoke((Object)t, new Object[0])) + SimpleAnsi.INTENSITY_NORMAL + SimpleAnsi.COLOR_DEFAULT;
                session.getConsole().println(str);
            }
            if (ShellUtil.getBoolean(session, "karaf.printStackTraces")) {
                session.getConsole().print(SimpleAnsi.COLOR_RED);
                t.printStackTrace(session.getConsole());
                session.getConsole().print(SimpleAnsi.COLOR_DEFAULT);
            } else if (!(t instanceof CloseShellException || t instanceof CommandException || isCommandNotFound)) {
                session.getConsole().print(SimpleAnsi.COLOR_RED);
                session.getConsole().println("Error executing command: " + (t.getMessage() != null ? t.getMessage() : t.getClass().getName()));
                session.getConsole().print(SimpleAnsi.COLOR_DEFAULT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getCurrentUserName() {
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (subject != null && subject.getPrincipals(UserPrincipal.class).iterator().hasNext()) {
            return subject.getPrincipals(UserPrincipal.class).iterator().next().getName();
        }
        return null;
    }
}

