/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.json.impl;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OrderedDictionary
extends Hashtable<String, Object>
implements Serializable {
    private static final long serialVersionUID = -525111601546803041L;
    private Map<CaseInsensitiveKey, Object> map = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        return this.map.containsKey(new CaseInsensitiveKey(key.toString()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Enumeration<String> keys() {
        return new KeyEnumeration(this.map.keySet().iterator());
    }

    @Override
    public Enumeration<Object> elements() {
        return Collections.enumeration(this.map.values());
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.map.get(new CaseInsensitiveKey(key.toString()));
    }

    @Override
    public Object put(String key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        CaseInsensitiveKey k = new CaseInsensitiveKey(key);
        Object oldValue = this.map.remove(k);
        this.map.put(k, value);
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(new CaseInsensitiveKey(key.toString()));
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    private static final class CaseInsentiveEntry
    implements Map.Entry<String, Object> {
        private final Map.Entry<CaseInsensitiveKey, Object> entry;

        CaseInsentiveEntry(Map.Entry<CaseInsensitiveKey, Object> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey().value;
        }

        @Override
        public Object getValue() {
            return this.entry.getValue();
        }

        @Override
        public Object setValue(Object value) {
            return this.entry.setValue(value);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CaseInsentiveEntry) {
                CaseInsentiveEntry other = (CaseInsentiveEntry)obj;
                return Objects.equals(other.entry.getKey(), this.entry.getKey()) && Objects.equals(other.entry.getValue(), this.entry.getValue());
            }
            if (obj instanceof Map.Entry) {
                Map.Entry other = (Map.Entry)obj;
                return Objects.equals(other.getKey(), this.entry.getKey()) && Objects.equals(other.getValue(), this.entry.getValue());
            }
            return false;
        }
    }

    private static final class EntryIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final Iterator<Map.Entry<CaseInsensitiveKey, Object>> i;

        EntryIterator(Collection<Map.Entry<CaseInsensitiveKey, Object>> c) {
            this.i = c.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            return new CaseInsentiveEntry(this.i.next());
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return OrderedDictionary.this.size();
        }

        @Override
        public boolean isEmpty() {
            return OrderedDictionary.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntryIterator(OrderedDictionary.this.map.entrySet());
        }

        @Override
        public void clear() {
            OrderedDictionary.this.clear();
        }
    }

    private static final class KeyIterator
    implements Iterator<String> {
        private final Iterator<CaseInsensitiveKey> i;

        KeyIterator(Collection<CaseInsensitiveKey> c) {
            this.i = c.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public String next() {
            CaseInsensitiveKey k = this.i.next();
            return k.value;
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    private final class KeySet
    extends AbstractSet<String> {
        private KeySet() {
        }

        @Override
        public int size() {
            return OrderedDictionary.this.size();
        }

        @Override
        public boolean isEmpty() {
            return OrderedDictionary.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return OrderedDictionary.this.containsKey(o);
        }

        @Override
        public Iterator<String> iterator() {
            return new KeyIterator(OrderedDictionary.this.map.keySet());
        }

        @Override
        public boolean remove(Object o) {
            return OrderedDictionary.this.remove(o) != null;
        }

        @Override
        public void clear() {
            OrderedDictionary.this.clear();
        }
    }

    private static class KeyEnumeration
    implements Enumeration<String> {
        private final Iterator<CaseInsensitiveKey> iterator;

        KeyEnumeration(Iterator<CaseInsensitiveKey> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next().value;
        }
    }

    private static final class CaseInsensitiveKey
    implements Serializable {
        private static final long serialVersionUID = 7040882564605268453L;
        private final String value;
        private final int hashCode;

        CaseInsensitiveKey(String v) {
            this.value = v;
            this.hashCode = v.toUpperCase().hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CaseInsensitiveKey)) {
                return false;
            }
            CaseInsensitiveKey other = (CaseInsensitiveKey)obj;
            if (this.value == null) {
                return other.value == null;
            }
            if (other.value == null) {
                return false;
            }
            return this.value.equalsIgnoreCase(other.value);
        }
    }
}

